% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_collection.R
\name{extent}
\alias{extent}
\title{Derive the spatiotemporal extent of an image collection}
\usage{
extent(x, srs = "EPSG:4326")
}
\arguments{
\item{x}{image collection proxy object}

\item{srs}{target spatial reference system}
}
\value{
a list with elements \code{left}, \code{right}, \code{bottom}, \code{top}, \code{t0} (start date/time), and \code{t1} (end date/time)
}
\description{
Derive the spatiotemporal extent of an image collection
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
extent(L8.col,"EPSG:32618")
cube_view(extent=extent(L8.col,"EPSG:32618"),
          srs="EPSG:32618", nx = 497, ny=526, dt="P1M")
}
