% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\name{print.cube}
\alias{print.cube}
\title{Print data cube information}
\usage{
\method{print}{cube}(x, ...)
}
\arguments{
\item{x}{Object of class "cube"}

\item{...}{Further arguments passed to the generic print function}
}
\description{
Prints information about the dimensions and bands of a data cube.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-01", t1="2018-12"),
              srs="EPSG:32618", nx = 497, ny=526, dt="P1M")
print(raster_cube(L8.col, v))
}
