% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.R
\name{reduce}
\alias{reduce}
\title{Reduce all bands of a data cube over the time dimension with a single reducer function}
\usage{
reduce(cube, reducer = c("mean", "median", "min", "max"))
}
\arguments{
\item{cube}{source data cube}

\item{reducer}{reducer function, currently "min", "max", "median", "mean", "count", "sd", "var", or "sum"}
}
\value{
proxy data cube object
}
\description{
Create a proxy data cube, which applies a single reducer function over per-band pixel time series of a data cube
}
\note{
Implemented reducers will ignore any NAN values (as na.rm=TRUE does).

This function returns a proxy object, i.e., it will not start any computations besides deriving the shape of the result.

This function is deprecated and will be replaced by the more flexible \code{\link{reduce_time}}.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-01", t1="2018-12"),
              srs="EPSG:32618", nx = 497, ny=526, dt="P1M")
L8.cube = raster_cube(L8.col, v) 
L8.rgb = select_bands(L8.cube, c("B02", "B03", "B04"))
L8.rgb.median = reduce(L8.rgb, "median")  
L8.rgb.median
}
