% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blc_sm.R
\name{batch_preprocess}
\alias{batch_preprocess}
\title{Batch reprocessing}
\usage{
batch_preprocess(
  path = ".",
  mod_t = 10,
  shift = 0,
  lambda = 20,
  gamma = 0.5,
  subtract = NULL,
  THR = 10^5,
  images = FALSE
)
}
\arguments{
\item{path}{a \emph{string} object. The path to the directory containing the
cdf files to be batch preprocessed and aligned.}

\item{mod_t}{a \emph{float} object. The modulation time for the GCxGC sample
analysis. Default is 10.}

\item{shift}{a \emph{float} object. The number of seconds to shift the phase
by. Default is 0 to skip shifting.}

\item{lambda}{a \emph{float} object. A number (parameter in Whittaker
smoothing), suggested between 1 to 10^5. Small lambda is very little
smoothing, large lambda is very smooth. Default is lambda = 20.}

\item{gamma}{a \emph{float} object. Correction factor between 0 and 1. 0
results in almost no values being subtracted to the baseline, 1 results in
almost everything except the peaks to be subtracted to the baseline. Default
is 0.5.}

\item{subtract}{a \emph{data.frame} object. Data frame containing TIC data
from a background sample or blank sample to be subtracted from the sample TIC
data.}

\item{THR}{a \emph{float} object. Threshold for peak intensity for peak
alignment. Should be a number between the baseline value and the highest peak
intensity. Default is THR = 100000.}

\item{images}{a \emph{boolean} object. An optional input. If TRUE, all images
of preprocessing steps will be displayed. Default is FALSE, no images will be
displayed.}
}
\value{
A \emph{data.frame} object. A list of pairs of data frames. A TIC
data frame and an MS data frame for each file.
}
\description{
\code{batch_preprocess} performs full preprocessing on a batch of
data files.
}
\details{
This function performs full preprocessing on a batch of data files.
Extracts data and performs peak alignment and performs smoothing and baseline
correction.
}
\examples{
folder <- system.file("extdata",package="gcxgclab")
frame_list <- batch_preprocess(folder,mod_t=.5,lambda=10,gamma=0.5,images=TRUE)

}
