% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate-plot.r
\name{calibrate_plot}
\alias{calibrate_plot}
\title{Calibration plot}
\usage{
calibrate_plot(
  y,
  p,
  distribution = "Bernoulli",
  replace = TRUE,
  line.par = list(col = "black"),
  shade_col = "lightyellow",
  shade_density = NULL,
  rug.par = list(side = 1),
  xlab = "Predicted value",
  ylab = "Observed average",
  xlim = NULL,
  ylim = NULL,
  knots = NULL,
  df = 6,
  ...
)
}
\arguments{
\item{y}{the outcome 0-1 variable}

\item{p}{the predictions estimating E(y|x)}

\item{distribution}{the loss function used in creating \code{p}.
\code{Bernoulli} and \code{Poisson} are currently the only special options.
All others default to squared error assuming \code{Gaussian}}

\item{replace}{determines whether this plot will replace or overlay the
current plot.  \code{replace=FALSE} is useful for comparing the calibration
of several methods}

\item{line.par}{graphics parameters for the line}

\item{shade_col}{color for shading the 2 SE region. \code{shade_col=NA}
implies no 2 SE region}

\item{shade_density}{the \code{density} parameter for \code{\link{polygon}}}

\item{rug.par}{graphics parameters passed to \code{\link{rug}}}

\item{xlab}{x-axis label corresponding to the predicted values}

\item{ylab}{y-axis label corresponding to the observed average}

\item{xlim, ylim}{x and y-axis limits. If not specified the function will
select limits}

\item{knots, df}{these parameters are passed directly to
\code{\link[splines]{ns}} for constructing a natural spline smoother for the
calibration curve}

\item{...}{other graphics parameters passed on to the plot function}
}
\value{
\code{calibrate.plot} returns no values.
}
\description{
An experimental diagnostic tool that plots the fitted values versus the
actual average values. If \code{distribution} is "Bernoulli" or "Poisson", 
then the predictions are converted to the response scale (probability or
rate). For all other distributions, the calibration plot uses least squares
and predicts an expected value.
}
\details{
Uses natural splines to estimate E(y|p). Well-calibrated predictions imply
that E(y|p) = p. The plot also includes a pointwise 95% confidence band.
}
\examples{

dataSim <- data.frame(x=rnorm(1000))
dataSim$y <- with(dataSim, rbinom(1000, 1, 1/(1+exp(-(x-0.5*x^2)))))

# showing poor calibration of a linear model
glm1 <- glm(y~x, data=dataSim, family=binomial)
p <- predict(glm1, type="response")
calibrate_plot(dataSim$y, p, xlim=c(0,1), ylim=c(0,1))

# showing better calibration with quadratic
glm1 <- glm(y~poly(x,2), data=dataSim, family=binomial)
p <- predict(glm1,type="response")
calibrate_plot(dataSim$y, p, xlim=c(0,1), ylim=c(0,1))

}
\references{
J.F. Yates (1982). "External correspondence: decomposition of
the mean probability score," Organisational Behaviour and Human Performance
30:132-156.

D.J. Spiegelhalter (1986). "Probabilistic Prediction in Patient Management
and Clinical Trials," Statistics in Medicine 5:421-433.
}
\author{
James Hickey, Greg Ridgeway \email{gregridgeway@gmail.com}
}
\keyword{hplot}
