% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_static_feeds.R
\name{get_system_calendar}
\alias{get_system_calendar}
\title{Save the system_calendar feed.}
\usage{
get_system_calendar(city, directory, file = "system_calendar.rds")
}
\arguments{
\item{city}{A character string or a url to an active gbfs.json feed.}

\item{directory}{The name of an existing folder or folder to be created, where the feed will
will be saved.}

\item{file}{The name of the file to be saved. Must end in .rds.}
}
\value{
A .rds object generated from the current system_calendar feed.
}
\description{
\code{get_system_calendar} saves the system_calendar feed for a given city as a .rds object. Go to 
`https://github.com/NABSA/gbfs/blob/master/gbfs.md` to see metadata for this dataset.
}
\examples{
\donttest{get_system_calendar(city = 
"http://biketownpdx.socialbicycles.com/opendata/system_calendar.json", directory = tempdir())}
\donttest{get_system_calendar(city = "Tampa", directory = tempdir())}
}
