% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgr2st.R
\name{fgr2st}
\alias{fgr2st}
\title{Calculates an independence graph using  repeated stepwise selection}
\usage{
fgr2st(x,p0=0.01,ind=0,kmn=0,kmx=0,nedge=10^5,inr=T,xinr=F)
}
\arguments{
\item{x}{Matrix of covariates}

\item{p0}{Cut-off P-value}

\item{ind}{Restricts the dependent nodes to this subset}

\item{kmn}{The minimum  number of selected variables for each node irrespective of cut-off P-value}

\item{kmx}{The maximum number of selected variables for each node irrespective of cut-off P-value}

\item{nedge}{Maximum number of edges}

\item{inr}{Logical, if TRUE include an intercept}

\item{xinr}{Logical, if TRUE intercept already included}

}
\value{
ned Number of edges

edg  List of edges giving nodes (covariates), the approximations for each node, the covariates in the approximation and the corresponding P-values.
}
\description{
Calculates a dependency graph using  repeated Gaussian stepwise selection
}
\examples{

data(redwine)
a<-fgr2st(redwine[,1:11],ind=4:8) 
}
