% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgraphst.R
\name{fgraphst}
\alias{fgraphst}
\title{Calculates an independence graph for a set of variables using stepwise selection}
\usage{
fgraphst(x, alpha, nu = 1, kmax = 0, intercept = TRUE,
  chkintercept = FALSE)
}
\arguments{
\item{x}{The variables}

\item{alpha}{Cut-off p-value}

\item{nu}{Order statistic}

\item{kmax}{Maximum number selected variables for each node}

\item{intercept}{If true intercept included}

\item{chkintercept}{If true intercept included depending on p-value}

}
\value{
ned Number of edges

edg The edges for each node in the graph
}
\description{
Calculates an independence graph for a set of variables using stepwise selection
}
\examples{
data(gausscov)
colongrph<-fgraphst(colon.x,0.05)
colongrph[[1]]
colongrph[[2]][1:10,]
}
