% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lv_interaction_log.R
\name{lv_interaction_log}
\alias{lv_interaction_log}
\title{Lotka-Volterra Interactions in Log Space}
\usage{
lv_interaction_log(time, n_log, parms)
}
\arguments{
\item{time}{The time steps corresponding to each observation - exists to interface with ode function, but should be left blank.}

\item{n_log}{A vector of species abundances, in log space}

\item{parms}{A vector of parameters - the first n elements should be the growth rates r1, r2, ... rn for all n species.
The remaining terms should be the elements of the interaction matrix A, listed in the order a11, a12, ... a1n, a21, a22, ... a2n, ... an1, an2, ... ann.}
}
\value{
vector of growth rates for each species in log space
}
\description{
Calculates dn/dt for n species in a Lokta-Volterra system, in log space,
following the form:
dlog(ni)/dt = (ri + aii * ni + sum_j(aij * nj))
This form can be helpful for optimization routines where species abundances
are close to zero.
}
\concept{Gause}
\concept{Lokta-Volterra}
\concept{interaction}
