% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitfuncs.r
\name{gastemptfunc}
\alias{gastemptfunc}
\alias{linexp}
\alias{linexp_slope}
\alias{linexp_auc}
\alias{powexp}
\alias{powexp_slope}
\alias{linexp_log}
\alias{powexp_log}
\title{Functions for gastric emptying analysis}
\usage{
linexp(t, v0 = 1, tempt = NULL, kappa = NULL, pars = NULL)

linexp_slope(t, v0 = 1, tempt = NULL, kappa = NULL, pars = NULL)

linexp_auc(v0 = 1, tempt = NULL, kappa = NULL, pars = NULL)

powexp(t, v0 = 1, tempt = NULL, beta = NULL, pars = NULL)

powexp_slope(t, v0 = 1, tempt = NULL, beta = NULL, pars = NULL)

linexp_log(t, v0 = 1, logtempt = NULL, logkappa = NULL, pars = NULL)

powexp_log(t, v0 = 1, logtempt = NULL, logbeta = NULL, pars = NULL)
}
\arguments{
\item{t}{Time after meal or start of scan, in minutes; can be a vector.}

\item{v0}{Initial volume at t=0.}

\item{tempt}{Emptying time constant in minutes (scalar).}

\item{kappa}{Overshoot term for linexp function (scalar).}

\item{pars}{Default NULL. If not NULL, the other parameters with exception
of \code{t} are not used and are retrieved as named parameters
from the numeric vector pars instead.}

\item{beta}{Power term for power exponential function (scalar).}

\item{logtempt}{Logarithm of emptying time constant in minutes (scalar).}

\item{logkappa}{Logarithm of overshoot term for linexp function (scalar).}

\item{logbeta}{Logarithm of power term for power exponential function (scalar).}
}
\value{
Vector of \code{length(t)} for computed volume.
}
\description{
The \code{linexp} and the power exponential (\code{powexp}) functions can
be used to fit gastric emptying curves.
}
\details{
The \code{linexp} function can have an initial overshoot
to model secretion.

\code{vol(t) = v0 * (1 + kappa * t / tempt) * exp(-t / tempt)}

The \code{powexp} function introduced by  Elashof et al. is
montonously decreasing but has more freedom to model details in the
function tail.

\code{vol(t) = v0 * exp(-(t / tempt) ^ beta)}
}
\examples{
t = seq(0,100, by=5)
kappa = 1.3
tempt = 60
v0 = 400
beta = 3
pars = c(v0 = v0, tempt = tempt, kappa = kappa)
par(mfrow=c(1,3))
plot(t, linexp(t, v0, tempt, kappa), type = "l", ylab = "volume",
   main = "linexp\\nkappa = 1.3 and 1.0")
lines(t, linexp(t, v0, tempt, 1), type = "l", col = "green")
# This should give the same plot as above
plot(t, linexp(t, pars = pars), type = "l", ylab = "volume",
   main = "linexp\\nkappa = 1.3 and 1.0\\nwith vectored parameters")
lines(t, linexp(t, v0, tempt, 1), type = "l", col = "green")
plot(t, powexp(t, v0, tempt, beta), type = "l", ylab = "volume",
  main = "powexp\\nbeta = 2 and 1")
lines(t, powexp(t, v0, tempt, 1), type = "l", col = "green")
}
\seealso{
Self starting functions  \code{\link{selfStart}}.
}
