% Generated by roxygen2 (4.0.1): do not edit by hand
\name{evaluatorUserFunction}
\alias{evaluatorUserFunction}
\title{User Defined Evaluator}
\usage{
evaluatorUserFunction(FUN, sepFUN = NULL, ...)
}
\arguments{
\item{FUN}{Function used to evaluate the fitness}

\item{sepFUN}{Function to calculate the SEP of the variable subsets}

\item{...}{Additional arguments passed to FUN and sepFUN}
}
\value{
Returns an S4 object of type \code{\link{GenAlgUserEvaluator}}
}
\description{
Create an evaluator that uses a user defined function to evaluate the fitness
}
\details{
The user specified function must take a the response vector as first and the covariates matrix as second argument.
The function must return a number representing the fitness of the variable subset (the higher the value the fitter the subset)
Additionally the user can specify a function that takes a \code{\link{GenAlg}} object and returns
the standard error of prediction of the found variable subsets.
}
\examples{
ctrl <- genAlgControl(populationSize = 100, numGenerations = 10, minVariables = 5,
    maxVariables = 12, verbosity = 1)

# Use the BIC of a linear model to evaluate the fitness of a variable subset
evalFUN <- function(y, X) {
		return(BIC(lm(y ~ X)));
}

# Dummy function that returns the residuals standard deviation and not the SEP
sepFUN <- function(genAlg) {
    return(apply(genAlg@subsets, 2, function(subset) {
		m <- lm(genAlg@response ~ genAlg@covariates[, subset]);
		return(sd(m$residuals));
	}));
}

evaluator <- evaluatorUserFunction(FUN = evalFUN, sepFUN = sepFUN)

# Generate demo-data
set.seed(12345)
X <- matrix(rnorm(10000, sd = 1:5), ncol = 50, byrow = TRUE)
y <- drop(-1.2 + rowSums(X[, seq(1, 43, length = 8)]) + rnorm(nrow(X), 1.5));

result <- genAlg(y, X, control = ctrl, evaluator = evaluator, seed = 123)

subsets(result, 1:5)
}
\seealso{
Other GenAlg.Evaluators: \code{\link{evaluatorFit}};
  \code{\link{evaluatorLM}}; \code{\link{evaluatorPLS}}
}

