% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapfill.R
\name{Validate}
\alias{Validate}
\alias{validate}
\title{Validation with RMSE}
\usage{
Validate(dataObserved, dataFilled, dataTrue, include = rep(TRUE,
  length(dataObserved)))
}
\arguments{
\item{dataObserved}{Numeric vector containing the observed data.}

\item{dataFilled}{Numeric vector containing the filled (predicted) data.
Needs to have the same length as \code{dataObserved}.}

\item{dataTrue}{Numeric vector containing the true data.
Needs to have the same length as \code{dataObserved}.}

\item{include}{Logical vector indicating which element to include in the
calculation of the RMSE.}
}
\value{
Numeric matrix with one 1 row and 6 columns having the entries:
\itemize{
\item \code{nNA}: number of missing values in \code{dataObserved},
\item \code{nFilled}: number of predicted values,
\item \code{nNotFilled}: number of not predicted missing values,
\item \code{ratioFilled}: ratio: \code{nFilled} / \code{nNA},
\item \code{nCrossvali}: number of values for validation,
\item \code{RMSE}: root mean squared error.
}
}
\description{
The function summarizes the validation scenario and
returns the root mean squared error (RMSE) of the predictions.
The typical validation procedure is: start with the \code{trueData}.
Remove some validation points to obtain artificially generated \code{dataObserved}.
Predicting the validation points based on \code{dataObserved} leads to \code{dataFilled}.
}
\examples{
Validate(c(1, NA, 2, NA), c(1, 2, 2, NA), c(1, 1, 2, 2))

## validate gap-fill predictions: consider the ndvi data
Image(ndvi)

## define some validation points vp
## in the image of the day 145 of the year 2004
vp <- 300 + c(5:10) + rep(21 * c(0:5), each = 6)

## remove the vp values from the data
nn <- ndvi
nn[vp] <- NA
Image(nn)

## predict the vp values 
out <- Gapfill(nn, subset = vp)
Validate(dataObserved = nn, dataFilled = out$fill,
         dataTrue = ndvi)

}
\author{
Florian Gerber, \email{florian.gerber@math.uzh.ch}.
}
