% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miamiplot.R
\name{miamiplot}
\alias{miamiplot}
\title{Miami plot}
\usage{
miamiplot(
  x,
  chr = "CHR",
  bp = "BP",
  p = "P",
  pr = "PR",
  snp = "SNP",
  col = c("midnightblue", "chartreuse4"),
  col2 = c("royalblue1", "seagreen1"),
  ymax = NULL,
  highlight = NULL,
  highlight.add = NULL,
  pch = 19,
  cex = 0.75,
  cex.lab = 1,
  xlab = "Chromosome",
  ylab = "-log10(P) [y>0]; log10(P) [y<0]",
  lcols = c("red", "black"),
  lwds = c(5, 2),
  ltys = c(1, 2),
  main = "",
  ...
)
}
\arguments{
\item{x}{Input data.}

\item{chr}{Chromsome.}

\item{bp}{Position.}

\item{p}{P value.}

\item{pr}{P value of the other GWAS.}

\item{snp}{Marker.}

\item{col}{Colors.}

\item{col2}{Colors.}

\item{ymax}{Max y.}

\item{highlight}{Highlight flag.}

\item{highlight.add}{Highlight meta-data.}

\item{pch}{Symbol.}

\item{cex}{cex.}

\item{cex.lab}{cex for labels.}

\item{xlab}{Label for x-axis.}

\item{ylab}{Label for y-axis.}

\item{lcols}{Colors.}

\item{lwds}{lwd.}

\item{ltys}{lty.}

\item{main}{Main title.}

\item{...}{Additional options.}
}
\value{
None.
}
\description{
The function allows for contrast of genomewide P values from two GWASs. It is conceptually simpler than at the first sight since it involves only one set of chromosomal positions.
}
\examples{
\dontrun{
  mhtdata <- within(mhtdata,{pr=p})
  miamiplot(mhtdata,chr="chr",bp="pos",p="p",pr="pr",snp="rsn")
}
}
