% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ganttify.R
\name{Ganttify}
\alias{Ganttify}
\title{Create Interactive Gantt Chart with WBS Structure}
\usage{
Ganttify(
  wbs_structure,
  activities,
  show_wbs_labels = TRUE,
  show_wbs_names_on_bars = TRUE,
  show_activity_names_on_bars = FALSE,
  show_today_line = TRUE,
  dim_past_activities = FALSE,
  dim_opacity = 0.3,
  wbs_colors = NULL,
  wbs_opacity = 0.3,
  wbs_bar_height = 0.3,
  activity_bar_height = 0.8,
  chart_title = "Project Gantt Chart with WBS",
  buffer_days = 30,
  indent_size = 4,
  x_range = NULL,
  max_visible_rows = 20,
  y_scroll_position = NULL
)
}
\arguments{
\item{wbs_structure}{A data frame with 3 columns: ID (character), Name (character),
and Parent (character). Parent should be "None" or "" for root level items.}

\item{activities}{A data frame with 5 required columns and 2 optional columns:
\itemize{
  \item WBS_ID (character): Associated WBS item identifier
  \item Activity_ID (character): Unique activity identifier
  \item Activity_Name (character): Activity name
  \item Start_Date (character): Planned start date in MM/DD/YYYY format
  \item End_Date (character): Planned end date in MM/DD/YYYY format
  \item Start_Date_Actual (character, optional): Actual start date in MM/DD/YYYY format
  \item End_Date_Actual (character, optional): Actual end date in MM/DD/YYYY format.
    If Start_Date_Actual is provided but End_Date_Actual is missing, the actual bar
    will show from Start_Date_Actual to today (if today > Start_Date_Actual).
}
When actual dates are provided, activities display as stacked bars: planned on top
(solid color) and actual on bottom (diagonal stripe pattern).}

\item{show_wbs_labels}{Logical. Show WBS item names on the y-axis. Default TRUE.}

\item{show_wbs_names_on_bars}{Logical. Show WBS names at the end of WBS bars. Default TRUE.}

\item{show_activity_names_on_bars}{Logical. Show activity names at the end of activity bars.
Default FALSE.}

\item{show_today_line}{Logical. Display a vertical line marking today's date. Default TRUE.}

\item{dim_past_activities}{Logical. Reduce opacity of activities that end before today.
Default FALSE.}

\item{dim_opacity}{Numeric. Opacity level for dimmed activities (0-1). Only used when
dim_past_activities is TRUE. Default 0.3.}

\item{wbs_colors}{Named list. Custom colors for each WBS ID (e.g., list("W1" = "#FF6B6B")).
If NULL, uses default color palette.}

\item{wbs_opacity}{Numeric. Opacity of WBS bars (0-1). Default 0.3.}

\item{wbs_bar_height}{Numeric. Height of WBS bars. Default 0.3.}

\item{activity_bar_height}{Numeric. Height of activity bars. Default 0.8.}

\item{chart_title}{Character. Title displayed at the top of the chart.
Default "Project Gantt Chart with WBS".}

\item{buffer_days}{Numeric. Number of days to add before and after the project timeline
for margin. Default 30.}

\item{indent_size}{Numeric. Number of spaces per indentation level in y-axis labels.
Default 4.}

\item{x_range}{Character vector. Date range for x-axis zoom (e.g., c("2024-01-01", "2024-12-31")).
If NULL, shows full project range.}

\item{max_visible_rows}{Numeric. Maximum number of rows visible at once (enables scrolling).
Default 20.}

\item{y_scroll_position}{Numeric. Initial scroll position (bottom of visible range).
If NULL, starts at the bottom.}
}
\value{
A plotly object containing the interactive Gantt chart. Can be displayed directly
  or saved using htmlwidgets::saveWidget().
}
\description{
Creates a Primavera-style interactive Gantt chart with Work Breakdown Structure (WBS)
hierarchy and activities. The chart features color-coded WBS items, indented labels,
scrollable view for large projects, and dynamic date formatting.
}
\examples{
\donttest{
# Load test data
data(test_project)

# Basic Gantt chart
chart <- Ganttify(
  wbs_structure = test_project$wbs_structure,
  activities = test_project$activities,
  wbs_colors = test_project$colors
)
chart

# With dimmed past activities
chart <- Ganttify(
  wbs_structure = test_project$wbs_structure,
  activities = test_project$activities,
  wbs_colors = test_project$colors,
  dim_past_activities = TRUE,
  dim_opacity = 0.4
)
chart

# With names on bars
chart <- Ganttify(
  wbs_structure = test_project$wbs_structure,
  activities = test_project$activities,
  wbs_colors = test_project$colors,
  show_wbs_names_on_bars = TRUE,
  show_activity_names_on_bars = TRUE
)
chart
}

}
