% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdPlotProjection.R
\name{gdPlotProjection}
\alias{gdPlotProjection}
\title{Create an image file for generative data and data source}
\usage{
gdPlotProjection(
  imageFileName,
  title,
  columnIndices,
  generativeDataParameters = gdPlotParameters(percent = 10, densityValueThresholds = c(),
    densityValueColors = c("red")),
  dataSourceParameters = gdPlotDataSourceParameters(percent = 100, color = "blue")
)
}
\arguments{
\item{imageFileName}{Name of image file}

\item{title}{Title of image}

\item{columnIndices}{Vector of two column indices that are used for the two-dimensional projections. Indices refer to indices of active columns of data source.}

\item{generativeDataParameters}{Plot generative data parameters, see function gdPlotParameters().}

\item{dataSourceParameters}{Plot data source parameters, see function gdPlotDataSourceParameters().}
}
\value{
None
}
\description{
Create an image file containing two-dimensional projections of generative data and data source.
Plot pagd_2500_6.binrameters for generative data and data source are passed by functions gdPlotParameters() and
gdPlotDataSourceParameters(). Data points of data source are drawn above data points of generative data.
}
\examples{
\dontrun{
gdRead("gd.bin", "ds.bin")
gdPlotProjection("gd12ddv.png",
 "Generative Data with a Density Value Threshold for the Iris Dataset", c(1, 2),
gdPlotParameters(250000, c(0.71), c("red", "green")),
gdPlotDataSourceParameters(2500))
gdPlotProjection("gd34ddv.png",
"Generative Data with a Density Value Threshold for the Iris Dataset", c(3, 4),
gdPlotParameters(250000, c(0.71), c("red", "green")),
gdPlotDataSourceParameters(2500))}
}
