% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah-package.R
\docType{package}
\name{galah}
\alias{galah-package}
\alias{galah}
\title{Biodiversity Data from the GBIF Node Network}
\description{
The Global Biodiversity Information Facility (GBIF; \url{https://www.gbif.org})
provides tools to enable users to find, access, combine and visualise
biodiversity data. \code{galah} enables the R community to directly access data and
resources hosted by GBIF and several of it's subsidiary organisations, known
as 'nodes'.

The basic unit of data stored by these infrastructures is
an \strong{occurrence} record, which is an observation of a biological entity at
a specific time and place. However, \code{galah} also facilitates access to
taxonomic information, or associated media such images or sounds,
all while restricting their queries to particular taxa or locations. Users
can specify which columns are returned by a query, or restrict their results
to observations that meet particular quality-control criteria.

For those outside Australia, 'galah' is the common name of
\emph{Eolophus roseicapilla}, a widely-distributed Australian bird species.
}
\section{Functions}{


\strong{Getting Started}
\itemize{
\item \code{\link[=galah_call]{galah_call()}}/\code{\link[=request_data]{request_()}} Start to build a query
\item \code{\link[=galah_config]{galah_config()}} Set package configuration options
\item \code{\link[=show_all]{show_all()}} & \code{\link[=search_all]{search_all()}} Data for generating filter queries
\item \code{\link[=show_values]{show_values()}} & \code{\link[=search_values]{search_values()}} Show or search for values \emph{within}
\code{fields}, \code{profiles}, \code{lists}, \code{collections}, \code{datasets} or \code{providers}
}

\strong{Amend a query}
\itemize{
\item \code{\link[=apply_profile]{apply_profile()}}/\code{\link[=galah_apply_profile]{galah_apply_profile()}} Restrict to data that pass predefined checks (ALA only)
\item \code{\link[=arrange.data_request]{arrange()}} Arrange rows of a query on the server side
\item \code{\link[=count.data_request]{count()}} Request counts of the specified data type
\item \code{\link[=desc]{desc()}} Arrange counts in descending order (when combined with \code{\link[=arrange.data_request]{arrange()}})
\item \code{\link[=filter.data_request]{filter()}}/\code{\link[=galah_filter]{galah_filter()}} Filter records
\item \code{\link[=geolocate]{geolocate()}}/\code{\link[=galah_geolocate]{galah_geolocate()}} Spatial filtering of a query
\item \code{\link[=group_by.data_request]{group_by()}}/\code{\link[=galah_group_by]{galah_group_by()}} Group counts by one or more fields
\item \code{\link[=identify.data_request]{identify()}}/\code{\link[=galah_identify]{galah_identify()}} Search for taxonomic identifiers (see also \code{\link[=taxonomic_searches]{taxonomic_searches}})
\item \code{\link[=select.data_request]{select()}}/\code{\link[=galah_select]{galah_select()}} Fields to report information for
\item \code{\link[=slice_head.data_request]{slice_head()}} Choose the first n rows of a download
\item \code{\link[=unnest]{unnest()}} Expand metadata for \code{fields}, \code{lists}, \code{profiles} or \code{taxa}
}

\strong{Execute a query via API}
\itemize{
\item \code{\link[=collapse.data_request]{collapse()}} Convert a \code{data_request} into a \code{query}
\item \code{\link[=compute.data_request]{compute()}} Compute a query
\item \code{\link[=collect.data_request]{collect()}}/\code{\link[=atlas_]{atlas_()}}/\code{\link[=collect_media]{collect_media()}} Retrieve a database query
}

\strong{Miscellaneous functions}
\itemize{
\item \code{\link[=atlas_citation]{atlas_citation()}} Get a citation for a dataset
\item \code{\link[=read_zip]{read_zip()}} To read data from an earlier download
\item \code{\link[=print.data_request]{print()}} Print functions for galah objects
}
}

\section{Terminology}{


To get the most value from \code{galah}, it is helpful to understand some
terminology. Each occurrence record contains taxonomic
information, and usually some information about the observation itself, such
as its location. In addition to this record-specific information, the living
atlases append contextual information to each record, particularly data from
spatial \strong{layers} reflecting climate gradients or political boundaries. They
also run a number of quality checks against each record, resulting in
\strong{assertions} attached to the record. Each piece of information
associated with a given occurrence record is stored in a \strong{field},
which corresponds to a \strong{column} when imported to an
\verb{R data.frame}. See \code{show_all(fields)} to view valid fields,
layers and assertions, or conduct a search using \code{search_all(fields)}.

Data fields are important because they provide a means to \strong{filter}
occurrence records;  i.e. to return only the information that you need, and
no more. Consequently, much of the architecture of \code{galah} has been
designed to make filtering as simple as possible. The easiest way to do this
is to start a pipe with \code{galah_call()} and follow it with the relevant
\code{dplyr} function; starting with \code{filter()}, but also including \code{select()},
\code{group_by()} or others. Functions without a relevant \code{dplyr} synonym include
\code{\link[=galah_identify]{galah_identify()}}/\code{identify()} for choosing a taxon, or \code{\link[=galah_geolocate]{galah_geolocate()}}/
\code{st_crop()} for choosing a specific location. By combining different filters,
it is possible to build complex queries to return only the most valuable
information for a given problem.

A notable extension of the filtering approach is to remove records with low
'quality'. All living atlases perform quality control checks on all records
that they store. These checks are used to generate new fields, that can then
be used to filter out records that are unsuitable for particular applications.
However, there are many possible data quality checks, and it is not always
clear which are most appropriate in a given instance. Therefore, \code{galah}
supports data quality \strong{profiles}, which can be passed to
\code{\link[=galah_apply_profile]{galah_apply_profile()}} to quickly remove undesirable records. A full list of
data quality profiles is returned by \code{show_all(profiles)}. Note this service
is currently only available for the Australian atlas (ALA).
}

\seealso{
Useful links:
\itemize{
  \item \url{https://galah.ala.org.au/R/}
  \item Report bugs at \url{https://github.com/AtlasOfLivingAustralia/galah-R/issues}
}

}
\author{
\strong{Maintainer}: Martin Westgate \email{martin.westgate@csiro.au}

Authors:
\itemize{
  \item Dax Kellie \email{dax.kellie@csiro.au}
  \item Matilda Stevenson
  \item Peggy Newman \email{peggy.newman@csiro.au}
}

}
\keyword{internal}
