% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_columns.R
\name{select_columns}
\alias{select_columns}
\title{Specify columns for occurrence download}
\usage{
select_columns(..., group = c("basic", "event", "assertions"))
}
\arguments{
\item{...}{zero or more individual column names to include}

\item{group}{\code{string}: (optional) name of one or more column groups to
include. Valid options are \code{"basic"}, \code{"event"} and
\code{"assertion"}}
}
\value{
An object of class \code{data.frame} and \code{ala_columns}
specifying the name and type of each column to include in the occurrence download.
}
\description{
The ALA stores content on hundreds of different fields, and users often
thousands or millions of records at a time. To reduce time taken to download
data, and limit complexity of the resulting \code{data.frame}, it is often
sensible to restrict the columns returned by \code{\link{ala_occurrences}()}
to those that are most critical for a given application. This function allows
easy selection of individual columns, or commonly-requested groups of columns.
The resulting \code{data.frame} is then passed to the \code{columns}
argument in \code{\link{ala_occurrences}()}.
}
\details{
Calling the argument \code{group = "basic"} returns the following columns:
\itemize{
  \item\code{decimalLatitude}
  \item\code{decimalLongitude}
  \item\code{eventDate}
  \item\code{scientificName}
  \item\code{taxonConceptID}
  \item\code{recordID}
  \item\code{dataResourceName}
}
Using \code{group = "event"} returns the following columns:
\itemize{
  \item\code{eventRemarks}
  \item\code{eventTime}
  \item\code{eventID}
  \item\code{eventDate}
  \item\code{samplingEffort}
  \item\code{samplingProtocol}
}
Using \code{group = "assertions"} returns all quality assertion-related
columns. The list of assertions is shown by \code{search_fields(type = "assertions")}.
}
\seealso{
\code{\link{select_taxa}}, \code{\link{select_filters}} and
\code{\link{select_locations}} for other ways to restrict the information returned
by \code{\link{ala_occurrences}} and related functions.
}
