## ---------------------------------------------------------------------------------------------------------------------
library(galah)
find_atlases()

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
#  ala_config(atlas = "UK", email = "your_email_here")

## ---------------------------------------------------------------------------------------------------------------------
ala_counts()

## ----error=TRUE-------------------------------------------------------------------------------------------------------
library(taxize)
# Use UK taxonomy
id <- get_nbnid("Vulpes vulpes", rows = 1)
ala_counts(taxa = id)

## ---------------------------------------------------------------------------------------------------------------------
# Download records from the Austrian atlas
ala_config(atlas = "Austria")
id <- get_gbifid("bombina variegata", rows = 1)
ala_counts(taxa = id)

## ----include = FALSE--------------------------------------------------------------------------------------------------
occ <- read.csv('bombina_variegata.csv')

## ----eval = FALSE-----------------------------------------------------------------------------------------------------
#  occ <- ala_occurrences(taxa = id)

## ---------------------------------------------------------------------------------------------------------------------
head(occ)

