% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vander-zanden-appendix.R
\name{vza_rescale}
\alias{vza_rescale}
\title{Parametric bootstrap for rescaling a la the vander zanden appendix}
\usage{
vza_rescale(SBL, vza_rescale_reps = 1000)
}
\arguments{
\item{SBL}{the data frame that summarizes the isotope feather data and
isoscape predictions at each location. This must have columns of \code{cnt},
\code{meanH}, \code{sdH}, \code{meaniso}, \code{sdiso}}

\item{vza_rescale_reps}{Number of simulated regressions to do.  Default is 1000.}
}
\value{
Returns a matrix with vza_rescale_reps rows.  Column 1 is "intercepts" and column
two is "slopes"
}
\description{
This is a vectorized and \strong{much} more efficient implementation
of the original \code{rescale} function from the Vander Zanden appendix.
It takes the output of \code{\link{group_birds_by_location}} directly
and does the parametric bootstrapping for vza_rescale_reps samples.
}
\keyword{internal}
