% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imodel_dmod.R
\name{imodel-dmod}
\alias{imodel-dmod}
\alias{dmod}
\alias{print.dModel}
\alias{fitted.dModel}
\alias{residuals.dModel}
\title{Discrete interaction model (log-linear model)}
\usage{
dmod(
  formula,
  data,
  marginal = NULL,
  interactions = NULL,
  fit = TRUE,
  details = 0,
  ...
)
}
\arguments{
\item{formula}{Model specification in one of the following forms: 1) a
right-hand sided formula, 2) as a list of generators, 3) an undirected
graph (represented either as an igraph object or as an adjacency
matrix).  Notice that there are certain model specification shortcuts,
see Section 'details' below.}

\item{data}{Either a table or a dataframe. In the latter case, the dataframe
will be coerced to a table. See 'details' below.}

\item{marginal}{Should only a subset of the variables be used in connection
with the model specification shortcuts}

\item{interactions}{A number given the highest order interactions in the
model, see Section 'details' below.}

\item{fit}{Should the model be fitted.}

\item{details}{Control the amount of output; for debugging purposes.}

\item{...}{Additional arguments; currently no used.}
}
\value{
An object of class \code{dModel}.
}
\description{
Specification of log--linear (graphical) model. The
'd' in the name \code{dmod} refers to that it is a (graphical)
model for 'd'iscrete variables
}
\details{
The independence model can be specified as \code{~.^1} and
\code{~.^.} specifies the saturated model.  Setting
e.g. \code{interactions=3} implies that there will be at most
three factor interactions in the model.

Data can be specified as a table of counts or as a dataframe. If
data is a dataframe then it will be converted to a table (using
\code{xtabs()}). This means that if the dataframe contains numeric
values then the you can get a very sparse and high dimensional
table. When a dataframe contains numeric values it may be
worthwhile to discretize data using the \code{cut()} function.

The \code{marginal} argument can be used for specifying the
independence or saturated models for only a subset of the
variables. When \code{marginal} is given the corresponding marginal
table of data is formed and used in the analysis (notice that this
is different from the behaviour of \code{loglin()} which uses the
full table.

The \code{triangulate()} method for discrete models (dModel
objects) will for a model look at the dependence graph for the
model.
}
\examples{
 
## Graphical log-linear model
data(reinis)
dm1 <- dmod(~ .^., reinis)
dm2 <- backward(dm1, k=2)
dm3 <- backward(dm1, k=2, fixin=list(c("family", "phys", "systol")))
## At most 3-factor interactions
dm1<-dmod(~ .^., data=reinis, interactions=3)
}
\seealso{
\code{\link{cmod}}, \code{\link{mmod}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
