% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglin-dimension.R
\name{dim-loglin}
\alias{dim-loglin}
\alias{dim_loglin}
\alias{dim_loglin_decomp}
\title{Return the dimension of a log-linear model}
\usage{
dim_loglin(glist, tableinfo)

dim_loglin_decomp(glist, tableinfo, adjust = TRUE)
}
\arguments{
\item{glist}{Generating class (a list) for a log-linear model. See
'details' below.}

\item{tableinfo}{Specification of the levels of the variables. See
'details' below.}

\item{adjust}{Should model dimension be adjusted for sparsity of
data (only available for decomposable models)}
}
\value{
A numeric.
}
\description{
Return the dimension of a log-linear model given by
the generating class 'glist'. If the model is decomposable and
adjusted dimension can be found.
}
\details{
\code{glist} can be either a list of vectors with variable names or a list
of vectors of variable indices.

\code{tableinfo} can be one of three different things.
\enumerate{
\item A contingency table (a \code{table}).
\item A list with the names of the variables and their levels (such as one
would get if calling \code{dimnames} on a \code{table}).
\item A vector with the levels. If \code{glist} is a list of vectors with
variable names, then the entries of the vector \code{tableinfo} must be
named.
}

If the model is decomposable it \code{dim_loglin_decomp} is to be preferred over
\code{dim_loglin} as the former is much faster.

Setting \code{adjust=TRUE} will force \code{dim_loglin_decomp} to calculated a
dimension which is adjusted for sparsity of data. For this to work,
\code{tableinfo} \emph{MUST} be a table.
}
\examples{
## glist contains variable names and tableinfo is a named vector:
dim_loglin(list(c("a", "b"), c("b", "c")), c(a=4, b=7, c=6))

## glist contains variable names and tableinfo is not named:
dim_loglin(list(c(1, 2), c(2, 3)), c(4, 7, 6))

## For decomposable models:
dim_loglin_decomp(list(c("a", "b"), c("b", "c")), c(a=4, b=7, c=6),adjust=FALSE)

}
\seealso{
\code{\link{dmod}}, \code{\link{glm}}, \code{\link{loglm}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
