% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grain-main.R
\name{grain-main}
\alias{grain-main}
\alias{grain}
\alias{grain.cpt_spec}
\alias{grain.CPTspec}
\alias{grain.pot_spec}
\alias{grain.graphNEL}
\alias{grain.dModel}
\title{Graphical Independence Network}
\usage{
grain(x, ...)

\method{grain}{cpt_spec}(x, control = list(), smooth = 0, compile = TRUE, details = 0, ...)

\method{grain}{CPTspec}(x, control = list(), smooth = 0, compile = TRUE, details = 0, ...)

\method{grain}{pot_spec}(x, control = list(), smooth = 0, compile = TRUE, details = 0, ...)

\method{grain}{graphNEL}(
  x,
  control = list(),
  smooth = 0,
  compile = TRUE,
  details = 0,
  data = NULL,
  ...
)

\method{grain}{dModel}(
  x,
  control = list(),
  smooth = 0,
  compile = TRUE,
  details = 0,
  data = NULL,
  ...
)
}
\arguments{
\item{x}{An argument to build an independence network
from. Typically a list of conditional probability tables, a DAG
or an undirected graph. In the two latter cases, data must also
be provided.}

\item{...}{Additional arguments, currently not used.}

\item{control}{A list defining controls, see 'details' below.}

\item{smooth}{A (usually small) number to add to the counts of a
table if the grain is built from a graph plus a dataset.}

\item{compile}{Should network be compiled.}

\item{details}{Debugging information.}

\item{data}{An optional data set (currently must be an array/table)}
}
\value{
An object of class "grain"
}
\description{
Creating grain objects (graphical independence network).
}
\details{
If 'smooth' is non-zero then entries of 'values' which a
zero are replaced by the value of 'smooth' - BEFORE any
normalization takes place.
}
\note{
A change from earlier versions of this package is that grain
objects are now compiled upon creation.
}
\examples{

## Create network from conditional probability tables CPTs:

yn   <- c("yes", "no")
a    <- cpt(~asia,              values=c(1,99), levels=yn)
t.a  <- cpt(~tub+asia,          values=c(5,95,1,99), levels=yn)
s    <- cpt(~smoke,             values=c(5,5), levels=yn)
l.s  <- cpt(~lung+smoke,        values=c(1,9,1,99), levels=yn)
b.s  <- cpt(~bronc+smoke,       values=c(6,4,3,7), levels=yn)
e.lt <- cpt(~either+lung+tub,   values=c(1,0,1,0,1,0,0,1), levels=yn)
x.e  <- cpt(~xray+either,       values=c(98,2,5,95), levels=yn)
d.be <- cpt(~dysp+bronc+either, values=c(9,1,7,3,8,2,1,9), levels=yn)
cpt_list  <- list(a, t.a, s, l.s, b.s, e.lt, x.e, d.be)
chest_cpt <- compileCPT(cpt_list)
## Alternative: chest_cpt <- compileCPT(a, t.a, s, l.s, b.s, e.lt, x.e, d.be)

chest_bn  <- grain(chest_cpt)

## Create network from data and graph specification.

data(lizard, package="gRbase")

## From a DAG: height <- species -> diam
daG <- dag(~species + height:species + diam:species)

## From an undirected graph UG : [height:species][diam:species]
uG  <- ug(~height:species + diam:species)

liz.ug   <- grain(uG, data=lizard)
liz.dag  <- grain(daG, data=lizard)
}
\references{
Søren Højsgaard (2012). Graphical Independence
Networks with the gRain Package for R. Journal of Statistical
Software, 46(10), 1-26.
\url{https://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{cptable}}, \code{\link{compile.grain}},
\code{\link{propagate.grain}}, \code{\link{setFinding}},
\code{\link{setEvidence}}, \code{\link{getFinding}},
\code{\link{pFinding}}, \code{\link{retractFinding}},
\code{\link{extractCPT}}, \code{\link{extractPOT}},
\code{\link{compileCPT}}, \code{\link{compilePOT}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
