% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{inHull}
\alias{inHull}
\title{Efficient test for points inside a convex hull in n dimensions. Inspired by
the Matlab code by John D'Errico
http://www.mathworks.com/matlabcentral/fileexchange/10226-inhull and
https://tolstoy.newcastle.edu.au/R/e8/help/09/12/8784.html}
\usage{
inHull(testPts, vertices, hull = geometry::convhulln(vertices),
  tol = mean(mean(abs(vertices))) * sqrt(.Machine$double.eps))
}
\arguments{
\item{testPts}{A nxp array to test, n data points, in p dimensions If you
have many points to test, it is most efficient to call this function once
with the entire set.}

\item{vertices}{A mxp array of vertices of the convex hull, as used by
convhulln.}

\item{hull}{Tessellation (or triangulation) generated by convhulln If hull is
left empty or not supplied, then it will be generated.}

\item{tol}{Tolerance on the tests for inclusion in the convex hull. You can
  think of tol as the distance a point may possibly lie outside the hull, and
  still be perceived as on the surface of the hull. Because of numerical slop
  nothing can ever be done exactly here. I might guess a semi-intelligent
  value of tol to be

  tol = 1.e-13*mean(abs(vertices(:)))

  In higher dimensions, the numerical issues of floating point arithmetic
  will probably suggest a larger value of tol.}
}
\value{
An integer vector of length n
}
\description{
Efficient test for points inside a convex hull in n dimensions. Inspired by
the Matlab code by John D'Errico
http://www.mathworks.com/matlabcentral/fileexchange/10226-inhull and
https://tolstoy.newcastle.edu.au/R/e8/help/09/12/8784.html
}
\author{
Lars Relund \email{lars@relund.dk}
}
