% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotPolytope}
\alias{plotPolytope}
\title{Create a plot of a polytope (bounded convex set)}
\usage{
plotPolytope(cPoints = NULL, points = NULL, showLbl = FALSE, iso = NULL,
  crit = "max", latex = FALSE, ...)
}
\arguments{
\item{cPoints}{Corner points in the polytope.}

\item{points}{Points to plot (e.g integer points inside the polytope or corner points).}

\item{showLbl}{Add labels to the points (only if points have a \code{lbl} column).}

\item{iso}{NULL or if 2D vector add the iso profit line the the solution plot.}

\item{crit}{Either max or min (only used if add the iso profit line)}

\item{latex}{If true make latex math labels for TikZ.}

\item{...}{Arguments passed to the \link{aes} function in \link{geom_point}.}
}
\value{
The ggplot2 object.
}
\description{
If an iso profit line added then the max/min is obtained among the \code{points}.
}
\examples{
# Define the LP max/min coeff*x st. Ax<=b, x>=0
A <- matrix(c(9,10,2,4,-3,2), ncol = 2, byrow = TRUE)
b <- c(90,27,3)
coeff <- c(7.75, 10)

# Corner points of the polytope
cPoints<-cornerPoints(A, b)
# Integer points in the polytope
iPoints<-integerPoints(A, b)

# Plot of the polytope
plotPolytope(cPoints)
plotPolytope(points = cPoints)
plotPolytope(points = iPoints)
plotPolytope(cPoints, cPoints, iso = coeff, crit = "max")
plotPolytope(cPoints, iPoints, iso = coeff, crit = "max")
plotPolytope(cPoints, iPoints, showLbl = TRUE)
plotPolytope(cPoints, iPoints, iso = c(3,-3), crit = "min")
plotPolytope(cPoints, iPoints) + xlab("x") + ylab("y")

# Plot of criterion points given a bi-objective vector
zPoints<-criterionPoints(iPoints, c1 = c(coeff[1], 0), c2 = c(0, coeff[2]), crit = "max")
head(zPoints)
plotCriterion(zPoints)
plotCriterion(zPoints, addHull = FALSE, addTriangles = TRUE)
# mimimize
zPoints<-criterionPoints(zPoints, c1 = c(-1, 1), c2 = c(1, -1), crit = "min")
plotCriterion(zPoints, addHull = TRUE, addTriangles = TRUE, crit = "min")
# identify solutions (x1,x2) corresponding to (z1,z2)
plotPolytope(cPoints, zPoints, showLbl = TRUE)
plotCriterion(zPoints, addHull = TRUE, addTriangles = TRUE, crit = "min", showLbl = TRUE)
# max and min
zPoints<-criterionPoints(iPoints, c1 = c(-2, -1), c2 = c(1, 4), crit = "max")
plotPolytope(cPoints, zPoints, showLbl = TRUE, shape = zPoints$nD)
plotCriterion(zPoints, addHull = TRUE, addTriangles = TRUE, crit = "max", showLbl = TRUE)
zPoints<-criterionPoints(iPoints, c1 = c(-2, -1), c2 = c(1, 4), crit = "min")
plotCriterion(zPoints, addHull = TRUE, addTriangles = TRUE, crit = "min", showLbl = TRUE)

\dontrun{
# Generate tikz file for LaTeX
library(tikzDevice)
tikz(file = "plot_polytope.tex", standAlone=F, width = 7, height = 6)
plotPolytope(cPoints, zPoints, showLbl = TRUE)
dev.off()
}

}
\author{
Lars Relund \email{lars@relund.dk}
}
