/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.widgets.buttons.HorizontalButtonPane;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.dialogs.PowerOptionsPanel;
import org.af.gMCP.gui.dialogs.TextFileViewer;
import org.af.gMCP.gui.graph.LaTeXTool;
import org.af.gMCP.gui.power.CVPanel;
import org.af.gMCP.gui.power.PDialog;
import org.af.gMCP.gui.power.ScenarioPanel;
import org.af.gMCP.gui.power.SettingsToXML;
import org.af.gMCP.gui.power.UserDefinedPanel;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerDialog
extends PDialog
implements ActionListener {
    Object[] variables;
    List<JTextField> jtlVar = new Vector<JTextField>();

    public PowerDialog(CreateGraphGUI parent) {
        super(parent, "Power Simulation - specify probability distribution of test statistics", true);
        this.config = new File(this.path, "gMCP-power-settings.xml");
        this.pNCP = new ScenarioPanel(this);
        this.tPanel.addTab("Noncentrality Parameter (NCP) Settings", (Component)((Object)this.pNCP));
        this.cvPanel = new CVPanel(this);
        this.tPanel.addTab("Correlation Matrix", this.cvPanel);
        this.userDefinedFunctions = new UserDefinedPanel(this, this.nodes);
        this.tPanel.addTab("User defined power function", this.userDefinedFunctions);
        this.oPanel = new PowerOptionsPanel(parent);
        this.tPanel.addTab("Options", this.oPanel);
        Set<String> variables = parent.getGraphView().getNL().getAllVariables();
        if (!Configuration.getInstance().getGeneralConfig().useEpsApprox()) {
            variables.remove("\u03b5");
        }
        if (variables.size() > 0) {
            this.tPanel.addTab("Variables", this.getVariablePanel(variables));
        }
        this.getContentPane().add((Component)this.tPanel, this.c);
        this.c.weighty = 0.0;
        ++this.c.gridy;
        this.c.weightx = 0.0;
        this.c.fill = 0;
        this.c.anchor = 13;
        HorizontalButtonPane bp = new HorizontalButtonPane(new String[]{"Help", "Ok", "Cancel"}, new String[]{"help", "OK", "CANCEL"});
        this.getContentPane().add((Component)bp, this.c);
        bp.addActionListener((ActionListener)this);
        if (this.config.exists()) {
            SettingsToXML.loadConfigFromXML(this.config, this);
        }
        this.pack();
        this.setLocationRelativeTo(parent);
        if (this.tmp && !Configuration.getInstance().getClassProperty(this.getClass(), "tellAboutFiles", "yes").equals("no")) {
            JCheckBox tellMeAgain = new JCheckBox("Don't show me this info again.");
            String message = "The settings in this dialog will be saved for further runs.\nIf you want these settings to be automatically saved not only\ntemporarily, but even between sessions, please specify a\ndirectory for saving these files in the options and reopen\nthis dialog.";
            JOptionPane.showMessageDialog(parent, new Object[]{message, tellMeAgain}, "Info", 1);
            if (tellMeAgain.isSelected()) {
                Configuration.getInstance().setClassProperty(this.getClass(), "tellAboutFiles", "no");
            }
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double alpha;
        try {
            alpha = this.parent.getPView().getTotalAlpha();
        }
        catch (Exception e1) {
            return;
        }
        if (e.getActionCommand().equals("OK")) {
            this.userDefinedFunctions.actionPerformed(null);
            if (RControl.getR().eval("any(is.na(" + this.cvPanel.getSigma() + "))").asRLogical().getData()[0]) {
                JOptionPane.showMessageDialog(this, "Correlation matrix for simulation can not contain NAs.", "No NAs allowed", 0);
                this.tPanel.setSelectedComponent(this.cvPanel);
                return;
            }
            SettingsToXML.saveSettingsToXML(this.config, this);
            this.rCommand = "gMCP:::calcMultiPower(graph=" + this.parent.getGraphView().getNL().getGraphName() + ", alpha=" + alpha + ", ncpL=" + this.pNCP.getNCPString() + "," + "corr.sim = " + this.cvPanel.getSigma() + this.cvPanel.getMatrixForParametricTest() + ", f = " + this.userDefinedFunctions.getUserDefined() + ", n.sim = " + Configuration.getInstance().getGeneralConfig().getNumberOfSimulations() + ", type = \"" + Configuration.getInstance().getGeneralConfig().getTypeOfRandom() + "\"" + this.getVariables() + ")";
            this.parent.glassPane.start();
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void doInBackground() throws Exception {
                    try {
                        RControl.setSeed();
                        String result = RControl.getR().eval(PowerDialog.this.rCommand).asRChar().getData()[0];
                        new TextFileViewer((JFrame)PowerDialog.this.parent, "Power results", result, true);
                    }
                    catch (Exception e) {
                        ErrorHandler.getInstance().makeErrDialog(e.getMessage(), (Object)e, false);
                    }
                    finally {
                        PowerDialog.this.parent.glassPane.stop();
                    }
                    return null;
                }
            };
            worker.execute();
        }
        if (e.getActionCommand().equals("help")) {
            if (this.tPanel.getSelectedComponent() == this.pNCP) {
                this.parent.openHelp("ncps");
            } else if (this.tPanel.getSelectedComponent() == this.cvPanel) {
                this.parent.openHelp("cormat2");
            } else if (this.tPanel.getSelectedComponent() == this.oPanel) {
                this.parent.openHelp("optNumeric");
            } else if (this.tPanel.getSelectedComponent() == this.userDefinedFunctions) {
                this.parent.openHelp("udpf");
            } else {
                this.parent.openHelp("power");
            }
        } else {
            this.dispose();
        }
    }

    public JPanel getVariablePanel(Set<String> v) {
        JPanel vPanel = new JPanel();
        this.variables = v.toArray();
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu";
        for (Object s : this.variables) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        vPanel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.jtlVar = new Vector<JTextField>();
        for (Object s : this.variables) {
            JTextField jt = new JTextField("0");
            if (s.equals("\u03b5")) {
                jt.setText("" + Configuration.getInstance().getGeneralConfig().getEpsilon());
            } else {
                jt.setText("" + Configuration.getInstance().getGeneralConfig().getVariable(s.toString()));
            }
            vPanel.add((Component)new JLabel("Value for '" + s + "':"), cc.xy(2, row));
            vPanel.add((Component)jt, cc.xy(4, row));
            this.jtlVar.add(jt);
            row += 2;
        }
        return vPanel;
    }

    public String getVariables() {
        if (this.jtlVar.size() > 0) {
            String s = ", variables=list(";
            for (int i = 0; i < this.variables.length; ++i) {
                s = s + LaTeXTool.UTF2LaTeX(this.variables[i].toString().charAt(0)) + " = " + this.jtlVar.get(i).getText();
                if (i == this.variables.length - 1) continue;
                s = s + ", ";
            }
            return s + ")";
        }
        return "";
    }
}

