% Generated by roxygen2 (4.0.1): do not edit by hand
\name{corMatWizard}
\alias{corMatWizard}
\title{Graphical User Interface for the creation of correlation matrices}
\usage{
corMatWizard(n = dim(matrix)[1], matrix = paste("diag(", n, ")"),
  names = paste("H", 1:n, sep = ""), envir = globalenv())
}
\arguments{
\item{n}{Square root of the dimension of the \eqn{n\times n}{nxn}-Matrix.}

\item{matrix}{Matrix of dimension \eqn{n\times n}{nxn} to start with.}

\item{names}{Row and column names.}

\item{envir}{Environment where the object \var{matrix} is located and/or it
should be saved (default is the global environment).}
}
\value{
The function itself returns NULL.  But with the dialog a symmetric
matrix of dimension \eqn{n\times n}{nxn} can be created or edited that will
be available in R under the specified variable name after saving.
}
\description{
Starts a graphical user interface for the correlation matrices.
}
\examples{
\dontrun{
corMatWizard(5)
C <- cor(matrix(rnorm(100),10), matrix(rnorm(100),10))
corMatWizard(matrix="C")
}
}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}
\keyword{graphs}
\keyword{misc}

