/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.af.commons.widgets.buttons.OkCancelButtonPane;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.datatable.CellEditorE;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.datatable.SingleDataFramePanel;
import org.af.gMCP.gui.dialogs.MatrixCreationDialog;
import org.af.gMCP.gui.dialogs.PowerParameterPanel;
import org.af.gMCP.gui.dialogs.TextFileViewer;
import org.af.gMCP.gui.dialogs.VariableNameDialog;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.Node;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerDialogParameterUncertainty
extends JDialog
implements ActionListener {
    JButton addAnother = new JButton("Add another power function");
    List<JButton> buttons = new Vector<JButton>();
    List<JButton> buttons2 = new Vector<JButton>();
    SingleDataFramePanel dfp;
    SingleDataFramePanel dfp2;
    JTextArea jta = new JTextArea();
    List<JTextField> jtl;
    List<JTextField> jtlMu;
    List<JTextField> jtlN;
    List<JTextField> jtlSigma;
    List<JTextField> jtlVar = new Vector<JTextField>();
    JTextField jtUserDefined = new JTextField();
    DefaultListModel listModel;
    JButton loadUDPF = new JButton("Load");
    JButton saveUDPF = new JButton("Save");
    JList listUserDefined;
    JCheckBox secondCV = new JCheckBox("Use another correlation matrix of test statistics used by the parametric test (misspecified or contains NA values)");
    JButton loadCV = new JButton("Load Matrix from R");
    JButton createCV = new JButton("Advanced Matrix Creation");
    JButton loadCV2 = new JButton("Load Matrix from R");
    JButton createCV2 = new JButton("Advanced Matrix Creation");
    JButton clearList = new JButton("Clear");
    boolean ncp = true;
    Vector<Node> nodes;
    CreateGraphGUI parent;
    PowerParameterPanel pPanelMeans;
    PowerParameterPanel pPanelSigmas;
    PowerParameterPanel pPanelN;
    JPanel panelMany = new JPanel();
    JTabbedPane tPanel = new JTabbedPane();
    Object[] variables;
    String rCommand = "";

    public static GridBagConstraints getDefaultGridBagConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 10;
        c.ipady = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        return c;
    }

    public PowerDialogParameterUncertainty(CreateGraphGUI parent) {
        super(parent, "Power Simulation - specify probability distribution of test statistics", true);
        this.setLocationRelativeTo(parent);
        this.parent = parent;
        this.nodes = parent.getGraphView().getNL().getNodes();
        RDataFrameRef df = new RDataFrameRef();
        RDataFrameRef df2 = new RDataFrameRef();
        for (Node n : this.nodes) {
            df.addRowCol(n.getName());
            df2.addRowCol(n.getName());
            df.setValue(df.getColumnCount() - 1, df.getColumnCount() - 1, new EdgeWeight(1.0));
            df2.setValue(df2.getColumnCount() - 1, df2.getColumnCount() - 1, new EdgeWeight(1.0));
        }
        this.dfp = new SingleDataFramePanel(df);
        this.dfp.getTable().getModel().checkCorMat();
        this.dfp.getTable().setDefaultEditor(EdgeWeight.class, new CellEditorE(null, this.dfp.getTable()));
        this.dfp.getTable().getModel().setCheckRowSum(false);
        this.dfp2 = new SingleDataFramePanel(df);
        this.dfp2.getTable().getModel().checkCorMat();
        this.dfp2.getTable().setDefaultEditor(EdgeWeight.class, new CellEditorE(null, this.dfp.getTable()));
        this.dfp2.getTable().getModel().setCheckRowSum(false);
        this.dfp2.setEnabled(false);
        if (parent.getPView().jrbRCorrelation.isSelected()) {
            try {
                String mat = parent.getPView().jcbCorObject.getSelectedItem().toString();
                this.load(this.dfp, mat);
                this.load(this.dfp2, mat);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (parent.getPView().jrbRCorrelation.isSelected()) {
            String name = parent.getPView().jcbCorObject.getSelectedItem().toString();
            try {
                double[] result = RControl.getR().eval("as.numeric(" + name + ")").asRNumeric().getData();
                int n = this.nodes.size();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n; ++j) {
                        this.dfp.getTable().getModel().setValueAt(new EdgeWeight(result[i * n + j]), i, j);
                        this.dfp2.getTable().getModel().setValueAt(new EdgeWeight(result[i * n + j]), i, j);
                    }
                }
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(this, "Could not load matrix \"" + name + "\":\n" + exc.getMessage(), "Could not load matrix", 0);
            }
        }
        parent.getPView().getParameters();
        GridBagConstraints c = PowerDialogParameterUncertainty.getDefaultGridBagConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        this.tPanel.addTab("NCP Settings", this.getMultiSettingPanel());
        this.tPanel.addTab("Correlation Matrix", this.getCVPanel());
        this.tPanel.addTab("User defined power function", this.getUserDefinedFunctions());
        Set<String> variables = parent.getGraphView().getNL().getAllVariables();
        if (!Configuration.getInstance().getGeneralConfig().useEpsApprox()) {
            variables.remove("\u03b5");
        }
        if (variables.size() > 0) {
            this.tPanel.addTab("Variables", this.getVariablePanel(variables));
        }
        this.getContentPane().add((Component)this.tPanel, c);
        c.weighty = 0.0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        OkCancelButtonPane bp = new OkCancelButtonPane();
        this.getContentPane().add((Component)bp, c);
        bp.addActionListener((ActionListener)this);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double alpha;
        if (e.getSource() == this.clearList) {
            this.listModel.removeAllElements();
            return;
        }
        if (e.getSource() == this.secondCV) {
            this.dfp2.setEnabled(this.secondCV.isSelected());
            this.loadCV2.setEnabled(this.secondCV.isSelected());
            this.createCV2.setEnabled(this.secondCV.isSelected());
            return;
        }
        if (e.getSource() == this.createCV) {
            MatrixCreationDialog mcd = new MatrixCreationDialog(this.parent, this.dfp.getTable().getRMatrix(), MatrixCreationDialog.getNames(this.parent.getGraphView().getNL().getNodes()));
            this.dfp.getTable().getModel().copy(mcd.dfp.getTable().getModel());
            return;
        }
        if (e.getSource() == this.createCV2) {
            MatrixCreationDialog mcd = new MatrixCreationDialog(this.parent, this.dfp2.getTable().getRMatrix(), MatrixCreationDialog.getNames(this.parent.getGraphView().getNL().getNodes()));
            this.dfp2.getTable().getModel().copy(mcd.dfp.getTable().getModel());
            return;
        }
        if (e.getSource() == this.loadCV) {
            this.load(this.dfp);
            return;
        }
        if (e.getSource() == this.loadCV2) {
            this.load(this.dfp2);
            return;
        }
        if (this.buttons.contains(e.getSource()) || this.buttons2.contains(e.getSource())) {
            this.jtUserDefined.setText(this.jtUserDefined.getText() + " " + ((JButton)e.getSource()).getActionCommand());
            return;
        }
        if (this.jtUserDefined.getText().length() > 0) {
            this.listModel.insertElementAt(this.jtUserDefined.getText(), 0);
            this.jtUserDefined.setText("");
        }
        if (e.getSource() == this.jtUserDefined || e.getSource() == this.addAnother) {
            return;
        }
        String weights = this.parent.getGraphView().getNL().getGraphName() + "@weights";
        try {
            alpha = this.parent.getPView().getTotalAlpha();
        }
        catch (Exception e1) {
            return;
        }
        String G = this.parent.getGraphView().getNL().getGraphName() + "@m";
        double[] means = new double[this.nodes.size()];
        String settings = null;
        String userDefinedF = this.getUserDefined();
        if (e.getActionCommand().equals("OK")) {
            settings = ", muL = " + this.pPanelMeans.getRList() + ", sigmaL = " + this.pPanelSigmas.getRList() + ", nL = " + this.pPanelN.getRList();
            this.rCommand = "gMCP:::calcMultiPower(weights=" + weights + ", alpha=" + alpha + ", G=" + G + settings + "," + "sigma = " + this.dfp.getTable().getModel().getDataFrame().getRMatrix() + this.getMatrixForParametricTest() + userDefinedF + ", nSim = " + Configuration.getInstance().getGeneralConfig().getNumberOfSimulations() + ", type = \"" + Configuration.getInstance().getGeneralConfig().getTypeOfRandom() + "\"" + this.getVariables() + ")";
            this.parent.glassPane.start();
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void doInBackground() throws Exception {
                    try {
                        String result = RControl.getR().eval(PowerDialogParameterUncertainty.this.rCommand).asRChar().getData()[0];
                        new TextFileViewer((JFrame)PowerDialogParameterUncertainty.this.parent, "Power results", result, true);
                    }
                    catch (Exception e) {
                        String message = e.getMessage();
                        JOptionPane.showMessageDialog(PowerDialogParameterUncertainty.this.parent, "R call produced an error:\n\n" + message + "\nWe will open a window with R code to reproduce this error for investigation.", "Error in R Call", 0);
                        JDialog d = new JDialog(PowerDialogParameterUncertainty.this.parent, "R Error", true);
                        d.add(new TextFileViewer((JFrame)PowerDialogParameterUncertainty.this.parent, "R Objects", "The following R code produced the following error:\n\n" + message + PowerDialogParameterUncertainty.this.rCommand, true));
                        d.pack();
                        d.setSize(800, 600);
                        d.setVisible(true);
                        e.printStackTrace();
                    }
                    finally {
                        PowerDialogParameterUncertainty.this.parent.glassPane.stop();
                    }
                    return null;
                }
            };
            worker.execute();
        }
        this.dispose();
    }

    private void load(SingleDataFramePanel dfp) {
        VariableNameDialog vnd = new VariableNameDialog(this.parent);
        this.load(dfp, vnd.getName());
    }

    private void load(SingleDataFramePanel dfp3, String name) {
        try {
            double[] result = RControl.getR().eval("as.numeric(" + name + ")").asRNumeric().getData();
            int n = this.nodes.size();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.dfp.getTable().getModel().setValueAt(new EdgeWeight(result[i * n + j]), i, j);
                }
            }
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this, "Could not load matrix \"" + name + "\":\n" + exc.getMessage(), "Could not load matrix", 0);
        }
    }

    public JPanel getCVPanel() {
        JPanel mPanel = new JPanel();
        GridBagConstraints c = PowerDialogParameterUncertainty.getDefaultGridBagConstraints();
        CellConstraints cc = new CellConstraints();
        int row = 2;
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        if (this.parent.getPView().jrbRCorrelation.isSelected()) {
            rows = rows + ", pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        }
        mPanel.setLayout((LayoutManager)new FormLayout(cols, rows));
        cc = new CellConstraints();
        mPanel.add((Component)new JLabel("Correlation matrix of test statistics for power simulations"), cc.xyw(2, row, 3));
        mPanel.add((Component)new JScrollPane(this.dfp), cc.xyw(2, row += 2, 3));
        mPanel.add((Component)this.loadCV, cc.xy(2, row += 2));
        this.loadCV.addActionListener(this);
        mPanel.add((Component)this.createCV, cc.xy(4, row));
        this.createCV.addActionListener(this);
        row += 2;
        if (this.parent.getPView().jrbRCorrelation.isSelected()) {
            mPanel.add((Component)this.secondCV, cc.xyw(2, row, 3));
            this.secondCV.addActionListener(this);
            mPanel.add((Component)new JScrollPane(this.dfp2), cc.xyw(2, row += 2, 3));
            mPanel.add((Component)this.loadCV2, cc.xy(2, row += 2));
            this.loadCV2.addActionListener(this);
            this.loadCV2.setEnabled(false);
            mPanel.add((Component)this.createCV2, cc.xy(4, row));
            this.createCV2.addActionListener(this);
            this.createCV2.setEnabled(false);
        }
        return mPanel;
    }

    private String getMatrixForParametricTest() {
        if (this.parent.getPView().jrbRCorrelation.isSelected()) {
            SingleDataFramePanel df = this.secondCV.isSelected() ? this.dfp2 : this.dfp;
            return ", cr=" + df.getTable().getModel().getDataFrame().getRMatrix() + ", test=\"" + Configuration.getInstance().getGeneralConfig().getParametricTest() + "\"";
        }
        return "";
    }

    public JPanel getMultiSettingPanel() {
        JPanel mPanel = new JPanel();
        JTabbedPane parameters = new JTabbedPane();
        this.pPanelMeans = new PowerParameterPanel("mean", 0.0, this.nodes, this.parent);
        this.pPanelSigmas = new PowerParameterPanel("sd", 1.0, this.nodes, this.parent);
        this.pPanelN = new PowerParameterPanel("sample size", 10.0, this.nodes, this.parent);
        parameters.addTab("Mean \u00b5", this.pPanelMeans);
        parameters.addTab("Standard deviation \u03c3", this.pPanelSigmas);
        parameters.addTab("Sample size n", this.pPanelN);
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        mPanel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        mPanel.add((Component)parameters, cc.xy(2, row));
        return mPanel;
    }

    private String getUserDefined() {
        if (this.listModel.getSize() == 0) {
            return "";
        }
        String s = ", f=list(";
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            s = s + "userDefined" + i + "=function(x) {" + this.listModel.get(i) + "}";
            if (i == this.listModel.getSize() - 1) continue;
            s = s + ",";
        }
        return s + ")";
    }

    public JPanel getUserDefinedFunctions() {
        JPanel mPanel = new JPanel();
        JButton b = new JButton("(");
        b.setActionCommand("(");
        this.buttons.add(b);
        b = new JButton(")");
        b.setActionCommand(")");
        this.buttons.add(b);
        b = new JButton("AND");
        b.setActionCommand("&&");
        this.buttons.add(b);
        b = new JButton("OR");
        b.setActionCommand("||");
        this.buttons.add(b);
        b = new JButton("NOT");
        b.setActionCommand("!");
        this.buttons.add(b);
        for (int i = 0; i < this.nodes.size(); ++i) {
            b = new JButton(this.nodes.get(i).getName());
            b.setActionCommand("x[" + (i + 1) + "]");
            this.buttons2.add(b);
        }
        JPanel hypPanel = new JPanel();
        for (JButton button : this.buttons2) {
            button.addActionListener(this);
            hypPanel.add(button);
        }
        JPanel opPanel = new JPanel();
        for (JButton button : this.buttons) {
            button.addActionListener(this);
            opPanel.add(button);
        }
        this.jta.setMargin(new Insets(4, 4, 4, 4));
        this.jta.setText("In the text field above you can enter an user defined power function.\nUse the R syntax and \"x[i]\" to specify the proposition that hypothesis i\ncould be rejected. Alternatively use the buttons below.\nExample:  (x[1] && x[2]) || x[4]\nThis calculates the probability that the first and second\nor (not exclusive) the fourth null hypothesis can be rejected.\nNote that you can use all R commands, for example also\nany(x) to see whether any hypotheses was rejected or\nall(x[1:4]) to see whether all of the first four hypotheses were rejected.\nHit return to add another power function.");
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        mPanel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.jtUserDefined.addActionListener(this);
        mPanel.add((Component)this.jtUserDefined, cc.xy(2, row));
        this.addAnother.addActionListener(this);
        mPanel.add((Component)this.addAnother, cc.xy(4, row));
        this.listModel = new DefaultListModel();
        this.listUserDefined = new JList(this.listModel);
        mPanel.add((Component)new JScrollPane(this.jta), cc.xywh(2, row += 2, 1, 3));
        mPanel.add((Component)new JScrollPane(this.listUserDefined), cc.xy(4, row));
        this.clearList.addActionListener(this);
        mPanel.add((Component)this.clearList, cc.xy(4, row += 2));
        mPanel.add((Component)new JScrollPane(hypPanel), cc.xyw(2, row += 2, 3));
        mPanel.add((Component)new JScrollPane(opPanel), cc.xyw(2, row += 2, 3));
        row += 2;
        return mPanel;
    }

    public JPanel getVariablePanel(Set<String> v) {
        JPanel vPanel = new JPanel();
        this.variables = v.toArray();
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu";
        for (Object s : this.variables) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        vPanel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.jtlVar = new Vector<JTextField>();
        for (Object s : this.variables) {
            JTextField jt = new JTextField("0");
            if (s.equals("\u03b5")) {
                jt.setText("" + Configuration.getInstance().getGeneralConfig().getEpsilon());
            } else {
                jt.setText("" + Configuration.getInstance().getGeneralConfig().getVariable(s.toString()));
            }
            vPanel.add((Component)new JLabel("Value for '" + s + "':"), cc.xy(2, row));
            vPanel.add((Component)jt, cc.xy(4, row));
            this.jtlVar.add(jt);
            row += 2;
        }
        return vPanel;
    }

    public String getVariables() {
        if (this.jtlVar.size() > 0) {
            String s = ", variables=list(";
            for (int i = 0; i < this.variables.length; ++i) {
                s = s + EdgeWeight.UTF2LaTeX(this.variables[i].toString().charAt(0)) + " = " + this.jtlVar.get(i).getText();
                if (i == this.variables.length - 1) continue;
                s = s + ", ";
            }
            return s + ")";
        }
        return "";
    }
}

