% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gMCP.extended.R
\name{weighted.test.functions}
\alias{weighted.test.functions}
\title{Weighted Test Functions for use with gMCP}
\description{
The package gMCP provides the following weighted test functions:
\describe{
  \item{bonferroni.test}{Bonferroni test - see \code{?bonferroni.test} for details.}
  \item{parametric.test}{Parametric test - see \code{?parametric.test} for details.}
  \item{simes.test}{Simes test - see \code{?simes.test} for details.}
  \item{bonferroni.trimmed.simes.test}{Trimmed Simes test for intersections of two hypotheses and otherwise Bonferroni - see \code{?bonferroni.trimmed.simes.test} for details.}
  \item{simes.on.subsets.test}{Simes test for intersections of hypotheses from certain sets and otherwise Bonferroni - see \code{?simes.on.subsets.test} for details.}
}
}
\details{
Depending on whether \code{adjPValues==TRUE} these test functions return different values:
\itemize{
  \item If \code{adjPValues==TRUE} the minimal value for alpha is returned for which the null hypothesis can be rejected. If that's not possible (for example in case of the trimmed Simes test adjusted p-values can not be calculated), the test function may throw an error.
  \item If \code{adjPValues==FALSE} a logical value is returned whether the null hypothesis can be rejected.
}

To provide your own test function write a function that takes at least the following arguments:
\describe{
  \item{pvalues}{A numeric vector specifying the p-values.}
  \item{weights}{A numeric vector of weights.}
  \item{alpha}{A numeric specifying the maximal allowed type one error rate. If \code{adjPValues==TRUE} (default) the parameter \code{alpha} should not be used.}
  \item{adjPValues}{Logical scalar. If \code{TRUE} an adjusted p-value for the weighted test is returned (if possible - if not the function should call \code{stop}).
Otherwise if \code{adjPValues==FALSE} a logical value is returned whether the null hypothesis can be rejected.}
  \item{...}{ Further arguments possibly passed by \code{gMCP} which will be used by other test procedures but not this one.}
}

Further the following parameters have a predefined meaning:
\describe{
  \item{verbose}{Logical scalar. If \code{TRUE} verbose output should be generated and printed to the standard output}
  \item{subset}{}
  \item{correlation}{}
}
}
\examples{

# The test function 'bonferroni.test' is used in by gMCP in the following call:
graph <- BonferroniHolm(4)
pvalues <- c(0.01, 0.05, 0.03, 0.02)
alpha <- 0.05
r <- gMCP.extended(graph=graph, pvalues=pvalues, test=bonferroni.test, verbose=TRUE)

# For the intersection of all four elementary hypotheses this results in a call
bonferroni.test(pvalues=pvalues, weights=getWeights(graph))
bonferroni.test(pvalues=pvalues, weights=getWeights(graph), adjPValues=FALSE)

# bonferroni.test function: 
bonferroni.test <- function(pvalues, weights, alpha=0.05, adjPValues=TRUE, verbose=FALSE, ...) {
  if (adjPValues) {
    return(min(pvalues/weights))
  } else {
    return(any(pvalues<=alpha*weights))
  }
}

}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}

