/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.datatable.CellEditorE;
import org.af.gMCP.gui.datatable.DataFramePanel;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.Node;

public class PowerDialogParameterUncertainty
extends JDialog
implements ActionListener {
    JButton ok = new JButton("Ok");
    CreateGraphGUI parent;
    Vector<Node> nodes;
    List<JTextField> jtl;
    JTextArea jta = new JTextArea();
    JPanel panel = new JPanel();
    DataFramePanel dfp;
    JTextField jtUserDefined = new JTextField();
    DefaultListModel listModel;
    JList listUserDefined;

    public PowerDialogParameterUncertainty(CreateGraphGUI parent) {
        super(parent, "Power Simulation - specify probability distribution of test statistics", true);
        this.setLocationRelativeTo(parent);
        this.parent = parent;
        this.nodes = parent.getGraphView().getNL().getNodes();
        RDataFrameRef df = new RDataFrameRef();
        for (Node n : parent.getGraphView().getNL().getNodes()) {
            df.addRowCol(n.getName());
            df.setValue(df.getColumnCount() - 1, df.getColumnCount() - 1, new EdgeWeight(1.0));
        }
        this.dfp = new DataFramePanel(df);
        this.dfp.getTable().getModel().diagEditable = true;
        this.dfp.getTable().setDefaultEditor(EdgeWeight.class, new CellEditorE(null, this.dfp.getTable()));
        this.jta.setText("Above you can specify the mean and covariance matrix of a multivariate\nnormal distribution that is used for power calculations.\n\nIn the text field on the right you can enter an user defined power function.\nExample:  (x[1] && x[2]) || x[4]\nThis calculates the probability that the first and second\nor (not exclusive) the fourth null hypothesis can be rejected.Hit return to add further user defined power functions.");
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu";
        for (Node n : this.nodes) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        this.panel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.jtl = new Vector<JTextField>();
        for (Node n : this.nodes) {
            JTextField jt = new JTextField("0");
            this.panel.add((Component)new JLabel("Mean for '" + n.getName() + "':"), cc.xy(2, row));
            this.panel.add((Component)jt, cc.xy(4, row));
            this.jtl.add(jt);
            row += 2;
        }
        this.ok.addActionListener(this);
        cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu, pref, 5dlu, pref";
        this.getContentPane().setLayout((LayoutManager)new FormLayout(cols, rows));
        cc = new CellConstraints();
        row = 2;
        this.getContentPane().add((Component)new JLabel("Mean of multivariate normal distribution"), cc.xy(2, row));
        this.getContentPane().add((Component)new JLabel("Covariance matrix"), cc.xy(4, row));
        this.getContentPane().add((Component)new JScrollPane(this.panel), cc.xy(2, row += 2));
        this.getContentPane().add((Component)new JScrollPane(this.dfp), cc.xy(4, row));
        this.listModel = new DefaultListModel();
        this.listUserDefined = new JList(this.listModel);
        this.getContentPane().add((Component)new JScrollPane(this.jta), cc.xy(2, row += 2));
        this.getContentPane().add((Component)new JScrollPane(this.listUserDefined), cc.xy(4, row));
        this.getContentPane().add((Component)this.jtUserDefined, cc.xy(4, row += 2));
        this.jtUserDefined.addActionListener(this);
        this.getContentPane().add((Component)this.ok, cc.xy(4, row += 2));
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.jtUserDefined.getText().length() > 0) {
            this.listModel.insertElementAt(this.jtUserDefined.getText(), 0);
            this.jtUserDefined.setText("");
        }
        if (e.getSource() == this.jtUserDefined) {
            return;
        }
        String weights = this.parent.getGraphView().getNL().getGraphName() + "@weights";
        double alpha = this.parent.getPView().getTotalAlpha();
        String G = this.parent.getGraphView().getNL().getGraphName() + "@m";
        double[] means = new double[this.nodes.size()];
        for (int i = 0; i < means.length; ++i) {
            means[i] = Double.parseDouble(this.jtl.get(i).getText());
        }
        String userDefinedF = this.getUserDefined();
        String mean = RControl.getRString(means);
        RControl.getR().eval(this.parent.getGraphView().getNL().getGraphName() + "<-gMCP:::parse2numeric(" + this.parent.getGraphView().getNL().getGraphName() + ")");
        RControl.getR().eval(".powerResult <- calcPower(weights=" + weights + ", alpha=" + alpha + ", G=" + G + ", mean=" + mean + "," + "sigma = " + this.dfp.getTable().getModel().getDataFrame().getRMatrix() + userDefinedF + ", nSim = " + Configuration.getInstance().getGeneralConfig().getNumberOfSimulations() + ", type = \"" + Configuration.getInstance().getGeneralConfig().getTypeOfRandom() + "\"" + ")");
        double[] localPower = RControl.getR().eval(".powerResult$LocalPower").asRNumeric().getData();
        double expRejections = RControl.getR().eval(".powerResult$ExpRejections").asRNumeric().getData()[0];
        double powAtlst1 = RControl.getR().eval(".powerResult$PowAtlst1").asRNumeric().getData()[0];
        double rejectAll = RControl.getR().eval(".powerResult$RejectAll").asRNumeric().getData()[0];
        Double[] userDefined = new Double[this.listModel.getSize()];
        String[] functions = new String[this.listModel.getSize()];
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            functions[i] = this.listModel.get(i).toString();
            userDefined[i] = RControl.getR().eval(".powerResult$userDefined" + i).asRNumeric().getData()[0];
        }
        this.parent.getGraphView().getNL().setPower(localPower, expRejections, powAtlst1, rejectAll, userDefined, functions);
        this.dispose();
    }

    private String getUserDefined() {
        if (this.listModel.getSize() == 0) {
            return "";
        }
        String s = ", f=list(";
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            s = s + "userDefined" + i + "=function(x) {" + this.listModel.get(i) + "}";
            if (i == this.listModel.getSize() - 1) continue;
            s = s + ",";
        }
        return s + ")";
    }
}

