/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.calendar.CalendarUtils;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import org.jdesktop.swingx.plaf.MonthViewUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMonthViewUI
extends MonthViewUI {
    private static final Logger LOG = Logger.getLogger(BasicMonthViewUI.class.getName());
    private static final int WEEKS_IN_MONTH = 6;
    private static final int CALENDAR_SPACING = 10;
    private static final Point NO_SUCH_CALENDAR = new Point(-1, -1);
    public static final int MONTH_DOWN = 1;
    public static final int MONTH_UP = 2;
    protected final SimpleDateFormat dayOfMonthFormatter = new SimpleDateFormat("d");
    protected String[] monthsOfTheYear;
    protected JXMonthView monthView;
    private PropertyChangeListener propertyChangeListener;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private Handler handler;
    private Date firstDisplayedDate;
    private int firstDisplayedMonth;
    private int firstDisplayedYear;
    private Date lastDisplayedDate;
    private boolean usingKeyboard = false;
    private Date pivotDate = null;
    private SortedSet<Date> originalDateSpan;
    protected Font derivedFont;
    protected boolean isLeftToRight;
    protected Icon monthUpImage;
    protected Icon monthDownImage;
    private Color weekOfTheYearForeground;
    private Color unselectableDayForeground;
    private Color leadingDayForeground;
    private Color trailingDayForeground;
    private int arrowPaddingX = 3;
    private int arrowPaddingY = 3;
    private Rectangle bounds = new Rectangle();
    @Deprecated
    private int startX;
    @Deprecated
    private int startY;
    private int monthBoxHeight;
    private int fullMonthBoxHeight;
    private int boxWidth;
    private int boxHeight;
    private int fullBoxWidth;
    private int fullBoxHeight;
    private int calendarWidth;
    private int calendarHeight;
    private int fullCalendarHeight;
    private int fullCalendarWidth;
    private int calendarRowCount = 1;
    private int calendarColumnCount = 1;
    protected Rectangle calendarGrid = new Rectangle();
    private Rectangle[] monthStringBounds = new Rectangle[12];
    private Rectangle[] yearStringBounds = new Rectangle[12];
    private String[] daysOfTheWeek;

    public static ComponentUI createUI(JComponent c) {
        return new BasicMonthViewUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.monthView = (JXMonthView)c;
        this.monthView.setLayout(this.createLayoutManager());
        this.isLeftToRight = this.monthView.getComponentOrientation().isLeftToRight();
        LookAndFeel.installProperty(this.monthView, "opaque", Boolean.TRUE);
        this.installComponents();
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.monthView.setLayout(null);
        this.monthView = null;
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installDefaults() {
        Color background = this.monthView.getBackground();
        if (background == null || background instanceof UIResource) {
            this.monthView.setBackground(UIManager.getColor("JXMonthView.background"));
        }
        this.monthView.setBoxPaddingX(UIManager.getInt("JXMonthView.boxPaddingX"));
        this.monthView.setBoxPaddingY(UIManager.getInt("JXMonthView.boxPaddingY"));
        this.monthView.setMonthStringBackground(UIManager.getColor("JXMonthView.monthStringBackground"));
        this.monthView.setMonthStringForeground(UIManager.getColor("JXMonthView.monthStringForeground"));
        this.monthView.setDaysOfTheWeekForeground(UIManager.getColor("JXMonthView.daysOfTheWeekForeground"));
        this.monthView.setSelectedBackground(UIManager.getColor("JXMonthView.selectedBackground"));
        this.monthView.setFlaggedDayForeground(UIManager.getColor("JXMonthView.flaggedDayForeground"));
        Font f = this.monthView.getFont();
        if (f == null || f instanceof UIResource) {
            this.monthView.setFont(UIManager.getFont("JXMonthView.font"));
        }
        this.monthDownImage = UIManager.getIcon("JXMonthView.monthDownFileName");
        this.monthUpImage = UIManager.getIcon("JXMonthView.monthUpFileName");
        this.weekOfTheYearForeground = UIManager.getColor("JXMonthView.weekOfTheYearForeground");
        this.leadingDayForeground = UIManager.getColor("JXMonthView.leadingDayForeground");
        this.trailingDayForeground = UIManager.getColor("JXMonthView.trailingDayForeground");
        this.unselectableDayForeground = UIManager.getColor("JXMonthView.unselectableDayForeground");
        this.derivedFont = this.createDerivedFont();
        this.setFirstDisplayedDay(this.monthView.getFirstDisplayedDay());
        this.updateLocale();
    }

    protected void uninstallDefaults() {
    }

    protected void installKeyboardActions() {
        this.installKeyBindings(0);
        ActionMap actionMap = this.monthView.getActionMap();
        KeyboardAction acceptAction = new KeyboardAction(0);
        actionMap.put("acceptSelection", acceptAction);
        KeyboardAction cancelAction = new KeyboardAction(1);
        actionMap.put("cancelSelection", cancelAction);
        actionMap.put("selectPreviousDay", new KeyboardAction(2));
        actionMap.put("selectNextDay", new KeyboardAction(3));
        actionMap.put("selectDayInPreviousWeek", new KeyboardAction(4));
        actionMap.put("selectDayInNextWeek", new KeyboardAction(5));
        actionMap.put("adjustSelectionPreviousDay", new KeyboardAction(6));
        actionMap.put("adjustSelectionNextDay", new KeyboardAction(7));
        actionMap.put("adjustSelectionPreviousWeek", new KeyboardAction(8));
        actionMap.put("adjustSelectionNextWeek", new KeyboardAction(9));
        actionMap.put("monthViewCommit", acceptAction);
        actionMap.put("monthViewCancel", cancelAction);
    }

    private void installKeyBindings(int type) {
        InputMap inputMap = this.monthView.getInputMap(type);
        inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "acceptSelection");
        inputMap.put(KeyStroke.getKeyStroke(27, 0, false), "cancelSelection");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "selectPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "selectNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "selectDayInPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "selectDayInNextWeek");
        inputMap.put(KeyStroke.getKeyStroke(37, 1, false), "adjustSelectionPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 1, false), "adjustSelectionNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 1, false), "adjustSelectionPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 1, false), "adjustSelectionNextWeek");
    }

    private void uninstallKeyBindings(int type) {
        InputMap inputMap = this.monthView.getInputMap(type);
        inputMap.clear();
    }

    protected void uninstallKeyboardActions() {
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.mouseListener = this.createMouseListener();
        this.mouseMotionListener = this.createMouseMotionListener();
        this.monthView.addPropertyChangeListener(this.propertyChangeListener);
        this.monthView.addMouseListener(this.mouseListener);
        this.monthView.addMouseMotionListener(this.mouseMotionListener);
        this.monthView.getSelectionModel().addDateSelectionListener(this.getHandler());
    }

    protected void uninstallListeners() {
        this.monthView.getSelectionModel().removeDateSelectionListener(this.getHandler());
        this.monthView.removeMouseMotionListener(this.mouseMotionListener);
        this.monthView.removeMouseListener(this.mouseListener);
        this.monthView.removePropertyChangeListener(this.propertyChangeListener);
        this.mouseMotionListener = null;
        this.mouseListener = null;
        this.propertyChangeListener = null;
    }

    protected void updateComponentInputMap() {
        if (this.monthView.isComponentInputMapEnabled()) {
            this.installKeyBindings(2);
        } else {
            this.uninstallKeyBindings(2);
        }
    }

    protected void updateLocale() {
        Locale locale = this.monthView.getLocale();
        this.monthsOfTheYear = new DateFormatSymbols(locale).getMonths();
        this.daysOfTheWeek = (String[])UIManager.get("JXMonthView.daysOfTheWeek");
        if (this.daysOfTheWeek == null) {
            this.daysOfTheWeek = new String[7];
            String[] dateFormatSymbols = new DateFormatSymbols(locale).getShortWeekdays();
            this.daysOfTheWeek = new String[7];
            for (int i = 1; i <= 7; ++i) {
                this.daysOfTheWeek[i - 1] = dateFormatSymbols[i];
            }
        }
        this.monthView.invalidate();
        this.monthView.validate();
    }

    @Override
    public String[] getDaysOfTheWeek() {
        String[] days = new String[this.daysOfTheWeek.length];
        System.arraycopy(this.daysOfTheWeek, 0, days, 0, days.length);
        return days;
    }

    protected Font createDerivedFont() {
        return this.monthView.getFont().deriveFont(1);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected LayoutManager createLayoutManager() {
        return this.getHandler();
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    public boolean isUsingKeyboard() {
        return this.usingKeyboard;
    }

    public void setUsingKeyboard(boolean val) {
        this.usingKeyboard = val;
    }

    protected Rectangle getDayBoundsAtLocation(int x, int y) {
        Rectangle days = this.getMonthDetailsBoundsAtLocation(x, y);
        if (days == null || !days.contains(x, y)) {
            return null;
        }
        int calendarRow = (y - days.y) / this.fullBoxHeight;
        int calendarColumn = (x - days.x) / this.fullBoxWidth;
        return new Rectangle(days.x + calendarColumn * this.fullBoxWidth, days.y + calendarRow * this.fullBoxHeight, this.fullBoxWidth, this.fullBoxHeight);
    }

    protected Point getDayGridPositionAtLocation(int x, int y) {
        Rectangle days = this.getMonthDetailsBoundsAtLocation(x, y);
        if (days == null || !days.contains(x, y)) {
            return null;
        }
        int calendarRow = (y - days.y) / this.fullBoxHeight;
        int calendarColumn = (x - days.x) / this.fullBoxWidth;
        if (!this.isLeftToRight) {
            int start = days.x + days.width;
            calendarColumn = (start - x) / this.fullBoxWidth;
        }
        if (this.monthView.isShowingWeekNumber()) {
            --calendarColumn;
        }
        return new Point(calendarColumn, calendarRow - 1);
    }

    protected Point getDayGridPosition(Date date) {
        if (!this.isVisible(date)) {
            return null;
        }
        Calendar calendar = this.getCalendar(date);
        Date startOfDay = CalendarUtils.startOfDay(calendar, date);
        CalendarUtils.startOfWeek(calendar);
        int column = 0;
        while (calendar.getTime().before(startOfDay)) {
            ++column;
            calendar.add(5, 1);
        }
        Date startOfWeek = CalendarUtils.startOfWeek(calendar, date);
        calendar.setTime(date);
        CalendarUtils.startOfMonth(calendar);
        int row = 0;
        while (calendar.getTime().before(startOfWeek)) {
            ++row;
            calendar.add(3, 1);
        }
        return new Point(column, row);
    }

    @Override
    public Date getDayAtLocation(int x, int y) {
        Point dayInGrid = this.getDayGridPositionAtLocation(x, y);
        if (dayInGrid == null || dayInGrid.x < 0 || dayInGrid.y < 0) {
            return null;
        }
        Date month = this.getMonthAtLocation(x, y);
        return this.getDayInMonth(month, dayInGrid.y, dayInGrid.x);
    }

    protected Rectangle getDayBounds(Date date) {
        if (!this.isVisible(date)) {
            return null;
        }
        Point position = this.getDayGridPosition(date);
        Rectangle monthBounds = this.getMonthBounds(date);
        monthBounds.y += this.getMonthHeaderHeight() + (position.y + 1) * this.fullBoxHeight;
        if (this.monthView.isShowingWeekNumber()) {
            ++position.x;
        }
        if (this.isLeftToRight) {
            monthBounds.x += position.x * this.fullBoxWidth;
        } else {
            int start = monthBounds.x + monthBounds.width - this.fullBoxWidth;
            monthBounds.x = start - position.x * this.fullBoxWidth;
        }
        monthBounds.width = this.fullBoxWidth;
        monthBounds.height = this.fullBoxHeight;
        return monthBounds;
    }

    private boolean isVisible(Date date) {
        return !this.getFirstDisplayedDay().after(date) && !this.getLastDisplayedDay().before(date);
    }

    protected Date getDayInMonth(Date month, int row, int column) {
        if (row < 0 || column < 0) {
            return null;
        }
        Calendar calendar = this.getCalendar(month);
        int monthField = calendar.get(2);
        if (!CalendarUtils.isStartOfMonth(calendar)) {
            throw new IllegalStateException("calendar must be start of month but was: " + month.getTime());
        }
        CalendarUtils.startOfWeek(calendar);
        calendar.add(5, row * 7 + column);
        if (calendar.get(2) == monthField) {
            return calendar.getTime();
        }
        return null;
    }

    protected int getTraversableGridPositionAtLocation(int x, int y) {
        Rectangle headerBounds = this.getMonthHeaderBoundsAtLocation(x, y);
        if (headerBounds == null) {
            return -1;
        }
        if (y < headerBounds.y + this.arrowPaddingY) {
            return -1;
        }
        if (y > headerBounds.y + headerBounds.height - this.arrowPaddingY) {
            return -1;
        }
        headerBounds.setBounds(headerBounds.x + this.arrowPaddingX, y, headerBounds.width - 2 * this.arrowPaddingX, headerBounds.height);
        if (!headerBounds.contains(x, y)) {
            return -1;
        }
        Rectangle hitArea = new Rectangle(headerBounds.x, headerBounds.y, this.monthUpImage.getIconWidth(), this.monthUpImage.getIconHeight());
        if (hitArea.contains(x, y)) {
            return this.isLeftToRight ? 1 : 2;
        }
        hitArea.translate(headerBounds.width - this.monthUpImage.getIconWidth(), 0);
        if (hitArea.contains(x, y)) {
            return this.isLeftToRight ? 2 : 1;
        }
        return -1;
    }

    protected Rectangle getMonthHeaderBoundsAtLocation(int x, int y) {
        Rectangle header = this.getMonthBoundsAtLocation(x, y);
        if (header == null) {
            return null;
        }
        header.height = this.getMonthHeaderHeight();
        return header;
    }

    private Rectangle getMonthDetailsBoundsAtLocation(int x, int y) {
        Rectangle month = this.getMonthBoundsAtLocation(x, y);
        if (month == null) {
            return null;
        }
        int startOfDaysY = month.y + this.getMonthHeaderHeight();
        if (y < startOfDaysY) {
            return null;
        }
        month.y = startOfDaysY;
        month.height -= this.getMonthHeaderHeight();
        return month;
    }

    protected Rectangle getMonthBoundsAtLocation(int x, int y) {
        if (!this.calendarGrid.contains(x, y)) {
            return null;
        }
        int calendarRow = (y - this.calendarGrid.y) / this.fullCalendarHeight;
        int calendarColumn = (x - this.calendarGrid.x) / this.fullCalendarWidth;
        return new Rectangle(this.calendarGrid.x + calendarColumn * this.fullCalendarWidth, this.calendarGrid.y + calendarRow * this.fullCalendarHeight, this.calendarWidth, this.calendarHeight);
    }

    protected Point getMonthGridPositionAtLocation(int x, int y) {
        if (!this.calendarGrid.contains(x, y)) {
            return null;
        }
        int calendarRow = (y - this.calendarGrid.y) / this.fullCalendarHeight;
        int calendarColumn = (x - this.calendarGrid.x) / this.fullCalendarWidth;
        if (!this.isLeftToRight) {
            int start = this.calendarGrid.x + this.calendarGrid.width;
            calendarColumn = (start - x) / this.fullCalendarWidth;
        }
        return new Point(calendarColumn, calendarRow);
    }

    protected Date getMonthAtLocation(int x, int y) {
        Point month = this.getMonthGridPositionAtLocation(x, y);
        if (month == null) {
            return null;
        }
        return this.getMonth(month.y, month.x);
    }

    protected Date getMonth(int row, int column) {
        Calendar calendar = this.getCalendar();
        calendar.add(2, row * this.calendarColumnCount + column);
        return calendar.getTime();
    }

    protected Point getMonthGridPosition(Date date) {
        if (!this.isVisible(date)) {
            return null;
        }
        Calendar calendar = this.getCalendar();
        int firstMonth = calendar.get(2);
        int firstYear = calendar.get(1);
        calendar.setTime(date);
        int month = calendar.get(2);
        int year = calendar.get(1);
        int diffMonths = month - firstMonth + (year - firstYear) * 12;
        int row = diffMonths / this.calendarColumnCount;
        int column = diffMonths % this.calendarColumnCount;
        return new Point(column, row);
    }

    protected Rectangle getMonthBounds(int row, int column) {
        int startY = this.calendarGrid.y + row * this.fullCalendarHeight;
        int startX = this.calendarGrid.x + column * this.fullCalendarWidth;
        if (!this.isLeftToRight) {
            startX = this.calendarGrid.x + (this.calendarColumnCount - 1 - column) * this.fullCalendarWidth;
        }
        return new Rectangle(startX, startY, this.calendarWidth, this.calendarHeight);
    }

    protected Rectangle getMonthBounds(Date date) {
        Point position = this.getMonthGridPosition(date);
        return position != null ? this.getMonthBounds(position.y, position.x) : null;
    }

    protected Dimension getMonthSize() {
        return new Dimension(this.calendarWidth, this.calendarHeight);
    }

    protected Dimension getDaySize() {
        return new Dimension(this.fullBoxWidth, this.fullBoxHeight);
    }

    protected int getMonthHeaderHeight() {
        return this.fullMonthBoxHeight;
    }

    private void calculateMonthGridLayoutProperties() {
        this.calculateMonthGridRowColumnCount();
        this.calculateMonthGridBounds();
    }

    private void calculateMonthGridBounds() {
        this.calculateStartPositionUnused();
        this.calendarGrid.setBounds(this.calculateCalendarGridX(), this.calculateCalendarGridY(), this.calculateCalendarGridWidth(), this.calculateCalendarGridHeight());
    }

    private int calculateCalendarGridY() {
        return (this.monthView.getHeight() - this.calculateCalendarGridHeight()) / 2;
    }

    private int calculateCalendarGridX() {
        return (this.monthView.getWidth() - this.calculateCalendarGridWidth()) / 2;
    }

    private int calculateCalendarGridHeight() {
        return this.calendarHeight * this.calendarRowCount + 10 * (this.calendarRowCount - 1);
    }

    private int calculateCalendarGridWidth() {
        return this.calendarWidth * this.calendarColumnCount + 10 * (this.calendarColumnCount - 1);
    }

    private void calculateMonthGridRowColumnCount() {
        int oldNumCalCols = this.calendarColumnCount;
        int oldNumCalRows = this.calendarRowCount;
        this.calendarColumnCount = 1;
        int addColumns = (this.monthView.getWidth() - this.calendarWidth) / (this.calendarWidth + 10);
        if (addColumns > 0) {
            this.calendarColumnCount += addColumns;
        }
        this.calendarRowCount = 1;
        int addRows = (this.monthView.getHeight() - this.calendarHeight) / (this.calendarHeight + 10);
        if (addRows > 0) {
            this.calendarRowCount += addRows;
        }
        if (oldNumCalCols != this.calendarColumnCount || oldNumCalRows != this.calendarRowCount) {
            this.updateLastDisplayedDay(this.getFirstDisplayedDay());
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2;
        super.paint(g, c);
        Object oldAAValue = null;
        Graphics2D graphics2D = g2 = g instanceof Graphics2D ? (Graphics2D)g : null;
        if (g2 != null && this.monthView.isAntialiased()) {
            oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Rectangle clip = g.getClipBounds();
        Graphics tmp = g.create();
        this.paintBackground(clip, tmp);
        tmp.dispose();
        g.setColor(this.monthView.getForeground());
        Calendar cal = this.getCalendar();
        for (int row = 0; row < this.calendarRowCount; ++row) {
            for (int column = 0; column < this.calendarColumnCount; ++column) {
                this.bounds = this.getMonthBounds(row, column);
                if (this.bounds.intersects(clip)) {
                    this.paintMonth(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, cal);
                }
                cal.add(2, 1);
            }
        }
        if (g2 != null && this.monthView.isAntialiased()) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        }
    }

    protected void paintMonth(Graphics g, int x, int y, int width, int height, Calendar calendar) {
        this.paintMonthStringBackground(g, x, y, width, this.fullMonthBoxHeight, calendar);
        this.paintMonthStringForeground(g, x, y, width, this.fullMonthBoxHeight, calendar);
        if (this.monthView.isTraversable()) {
            this.monthDownImage.paintIcon(this.monthView, g, x + this.arrowPaddingX, y + (this.fullMonthBoxHeight - this.monthDownImage.getIconHeight()) / 2);
            this.monthUpImage.paintIcon(this.monthView, g, x + width - this.arrowPaddingX - this.monthUpImage.getIconWidth(), y + (this.fullMonthBoxHeight - this.monthDownImage.getIconHeight()) / 2);
        }
        boolean showingWeekNumber = this.monthView.isShowingWeekNumber();
        int tmpX = this.isLeftToRight ? x + (showingWeekNumber ? this.fullBoxWidth : 0) : x;
        int tmpY = y + this.fullMonthBoxHeight;
        int tmpWidth = width - (showingWeekNumber ? this.fullBoxWidth : 0);
        this.paintDayOfTheWeekBackground(g, tmpX, tmpY, tmpWidth, this.fullBoxHeight, calendar);
        int dayIndex = this.monthView.getFirstDayOfWeek() - 1;
        Font oldFont = this.monthView.getFont();
        g.setFont(this.derivedFont);
        g.setColor(this.monthView.getDaysOfTheWeekForeground());
        FontMetrics fm = this.monthView.getFontMetrics(this.derivedFont);
        String[] daysOfTheWeek = this.monthView.getDaysOfTheWeek();
        for (int i = 0; i < 7; ++i) {
            int n = tmpX = this.isLeftToRight ? x + i * this.fullBoxWidth + this.monthView.getBoxPaddingX() + this.boxWidth / 2 - fm.stringWidth(daysOfTheWeek[dayIndex]) / 2 : x + width - i * this.fullBoxWidth - this.monthView.getBoxPaddingX() - this.boxWidth / 2 - fm.stringWidth(daysOfTheWeek[dayIndex]) / 2;
            if (showingWeekNumber) {
                tmpX += this.isLeftToRight ? this.fullBoxWidth : -this.fullBoxWidth;
            }
            tmpY = y + this.fullMonthBoxHeight + this.monthView.getBoxPaddingY() + fm.getAscent();
            g.drawString(daysOfTheWeek[dayIndex], tmpX, tmpY);
            if (++dayIndex != 7) continue;
            dayIndex = 0;
        }
        g.setFont(oldFont);
        int yNew = y + this.fullMonthBoxHeight + this.fullBoxHeight;
        this.paintWeeksOfYear(g, x, yNew, width, calendar);
        int xOffset = 0;
        if (this.monthView.isShowingWeekNumber()) {
            xOffset = this.fullBoxWidth;
        }
        if (this.isLeftToRight) {
            this.paintDays(g, x + xOffset, yNew, width - xOffset, calendar);
        } else {
            this.paintDays(g, x, yNew, width - xOffset, calendar);
        }
    }

    protected void paintDays(Graphics g, int left, int top, int width, Calendar cal) {
        Calendar calendar = (Calendar)cal.clone();
        CalendarUtils.startOfMonth(calendar);
        Date startOfMonth = calendar.getTime();
        CalendarUtils.endOfMonth(calendar);
        Date endOfMonth = calendar.getTime();
        calendar.setTime(cal.getTime());
        calendar.setTime(cal.getTime());
        CalendarUtils.startOfWeek(calendar);
        int topOfDay = top;
        for (int week = 0; week < 6; ++week) {
            int leftOfDay = this.isLeftToRight ? left : left + width - this.fullBoxWidth;
            for (int day = 0; day < 7; ++day) {
                if (calendar.getTime().before(startOfMonth)) {
                    this.paintLeadingDay(g, leftOfDay, topOfDay, calendar);
                } else if (calendar.getTime().after(endOfMonth)) {
                    this.paintTrailingDay(g, leftOfDay, topOfDay, calendar);
                } else {
                    this.paintDay(g, leftOfDay, topOfDay, calendar);
                }
                leftOfDay = this.isLeftToRight ? leftOfDay + this.fullBoxWidth : leftOfDay - this.fullBoxWidth;
                calendar.add(5, 1);
            }
            topOfDay += this.fullBoxHeight;
        }
    }

    protected void paintDay(Graphics g, int left, int top, Calendar calendar) {
        if (this.monthView.isUnselectableDate(calendar.getTime())) {
            this.paintUnselectableDayBackground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
            this.paintUnselectableDayForeground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
        } else if (this.monthView.isFlaggedDate(calendar.getTime())) {
            this.paintFlaggedDayBackground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
            this.paintFlaggedDayForeground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
        } else {
            this.paintDayBackground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
            this.paintDayForeground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
        }
    }

    protected void paintTrailingDay(Graphics g, int left, int top, Calendar calendar) {
        if (!this.monthView.isShowingTrailingDays()) {
            return;
        }
        this.paintTrailingDayBackground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
        this.paintTrailingDayForeground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
    }

    protected void paintLeadingDay(Graphics g, int left, int top, Calendar calendar) {
        if (!this.monthView.isShowingLeadingDays()) {
            return;
        }
        this.paintLeadingDayBackground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
        this.paintLeadingDayForeground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
    }

    protected int getWeeks(Calendar month) {
        Date old = month.getTime();
        CalendarUtils.startOfWeek(month);
        int firstWeek = month.get(3);
        month.setTime(old);
        CalendarUtils.endOfMonth(month);
        int lastWeek = month.get(3);
        if (lastWeek < firstWeek) {
            lastWeek = month.getActualMaximum(3) + 1;
        }
        month.setTime(old);
        return lastWeek - firstWeek;
    }

    protected void paintWeeksOfYear(Graphics g, int x, int initialY, int width, Calendar cal) {
        if (!this.monthView.isShowingWeekNumber()) {
            return;
        }
        int tmpX = this.isLeftToRight ? x : x + width - this.fullBoxWidth;
        this.paintWeekOfYearBackground(g, tmpX, initialY, this.fullBoxWidth, this.calendarHeight - (this.fullMonthBoxHeight + this.fullBoxHeight), cal);
        Calendar calendar = (Calendar)cal.clone();
        int weeks = this.getWeeks(calendar);
        calendar.setTime(cal.getTime());
        for (int weekOfYear = 0; weekOfYear <= weeks; ++weekOfYear) {
            this.paintWeekOfYearForeground(g, tmpX, initialY, this.fullBoxWidth, this.fullBoxHeight, calendar);
            initialY += this.fullBoxHeight;
            calendar.add(3, 1);
        }
    }

    protected void paintDayOfTheWeekBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        int boxPaddingX = this.monthView.getBoxPaddingX();
        g.drawLine(x + boxPaddingX, y + height - 1, x + width - boxPaddingX, y + height - 1);
    }

    protected void paintWeekOfYearBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        int boxPaddingY = this.monthView.getBoxPaddingY();
        x = this.isLeftToRight ? x + width - 1 : x;
        g.drawLine(x, y + boxPaddingY, x, y + height - boxPaddingY);
    }

    protected void paintWeekOfYearForeground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        String str = Integer.toString(cal.get(3));
        g.setColor(this.weekOfTheYearForeground);
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        FontMetrics fm = g.getFontMetrics();
        g.drawString(str, this.isLeftToRight ? x + boxPaddingX + this.boxWidth - fm.stringWidth(str) : x + boxPaddingX + this.boxWidth - fm.stringWidth(str) - 1, y + boxPaddingY + fm.getAscent());
    }

    protected void paintMonthStringBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        Insets monthStringInsets = this.monthView.getMonthStringInsets();
        x = this.isLeftToRight ? x + monthStringInsets.left : x + monthStringInsets.right;
        width = width - monthStringInsets.left - monthStringInsets.right;
        height = height - monthStringInsets.top - monthStringInsets.bottom;
        g.setColor(this.monthView.getMonthStringBackground());
        g.fillRect(x, y += monthStringInsets.top, width, height);
    }

    protected void paintMonthStringForeground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        Font oldFont = this.monthView.getFont();
        g.setFont(this.derivedFont);
        FontMetrics fm = this.monthView.getFontMetrics(this.derivedFont);
        int month = cal.get(2);
        String monthName = this.monthsOfTheYear[month];
        String yearString = Integer.toString(cal.get(1));
        Rectangle2D rect = fm.getStringBounds(monthName, g);
        this.monthStringBounds[month] = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
        int spaceWidth = (int)fm.getStringBounds(" ", g).getWidth();
        rect = fm.getStringBounds(yearString, g);
        this.yearStringBounds[month] = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
        g.setColor(this.monthView.getMonthStringForeground());
        int tmpX = x + this.calendarWidth / 2 - (this.monthStringBounds[month].width + this.yearStringBounds[month].width + spaceWidth) / 2;
        int tmpY = y + this.monthView.getBoxPaddingY() + (this.monthBoxHeight - this.boxHeight) / 2 + fm.getAscent();
        this.monthStringBounds[month].x = tmpX;
        this.yearStringBounds[month].x = this.monthStringBounds[month].x + this.monthStringBounds[month].width + spaceWidth;
        this.paintMonthStringForeground(g, monthName, this.monthStringBounds[month].x, tmpY, yearString, this.yearStringBounds[month].x, tmpY, cal);
        g.setFont(oldFont);
    }

    protected void paintMonthStringForeground(Graphics g, String monthName, int monthX, int monthY, String yearName, int yearX, int yearY, Calendar cal) {
        g.drawString(monthName, monthX, monthY);
        g.drawString(yearName, yearX, yearY);
    }

    protected void paintDayBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        Date date = cal.getTime();
        if (this.monthView.isSelected(date)) {
            g.setColor(this.monthView.getSelectedBackground());
            g.fillRect(x, y, width, height);
        }
        if (this.isToday(date)) {
            g.setColor(this.monthView.getTodayBackground());
            g.drawRect(x, y, width - 1, height - 1);
        }
    }

    protected void paintDayForeground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        String numericDay = this.dayOfMonthFormatter.format(cal.getTime());
        g.setColor(this.monthView.getDayForeground(cal.get(7)));
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        this.paintDayForeground(g, numericDay, this.isLeftToRight ? x + boxPaddingX + this.boxWidth : x + boxPaddingX + this.boxWidth - 1, y + boxPaddingY, cal);
    }

    protected void paintDayForeground(Graphics g, String numericDay, int x, int y, Calendar cal) {
        FontMetrics fm = g.getFontMetrics();
        g.drawString(numericDay, x - fm.stringWidth(numericDay), y + fm.getAscent());
    }

    protected void paintFlaggedDayBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        this.paintDayBackground(g, x, y, width, height, cal);
    }

    protected void paintFlaggedDayForeground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        Date date = cal.getTime();
        String numericDay = this.dayOfMonthFormatter.format(date);
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        Font oldFont = this.monthView.getFont();
        g.setColor(this.monthView.getFlaggedDayForeground());
        g.setFont(this.derivedFont);
        FontMetrics fm = this.monthView.getFontMetrics(this.derivedFont);
        g.drawString(numericDay, this.isLeftToRight ? x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay) : x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay) - 1, y + boxPaddingY + fm.getAscent());
        g.setFont(oldFont);
    }

    protected void paintUnselectableDayBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        this.paintDayBackground(g, x, y, width, height, cal);
    }

    protected void paintUnselectableDayForeground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        this.paintDayForeground(g, x, y, width, height, cal);
        g.setColor(this.unselectableDayForeground);
        String numericDay = this.dayOfMonthFormatter.format(cal.getTime());
        FontMetrics fm = this.monthView.getFontMetrics(this.derivedFont);
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        width = fm.stringWidth(numericDay);
        height = fm.getAscent();
        x = this.isLeftToRight ? x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay) : x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay) - 1;
        g.drawLine(x, y += boxPaddingY, x + width, y + height);
        g.drawLine(x + 1, y, x + width + 1, y + height);
        g.drawLine(x + width, y, x, y + height);
        g.drawLine(x + width - 1, y, x - 1, y + height);
    }

    protected void paintLeadingDayBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        this.paintDayBackground(g, x, y, width, height, cal);
    }

    protected void paintLeadingDayForeground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        String numericDay = this.dayOfMonthFormatter.format(cal.getTime());
        g.setColor(this.leadingDayForeground);
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        FontMetrics fm = g.getFontMetrics();
        int ltorOffset = x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay);
        g.drawString(numericDay, this.isLeftToRight ? ltorOffset : ltorOffset - 1, y + boxPaddingY + fm.getAscent());
    }

    protected void paintTrailingDayBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        this.paintLeadingDayBackground(g, x, y, width, height, cal);
    }

    protected void paintTrailingDayForeground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        String numericDay = this.dayOfMonthFormatter.format(cal.getTime());
        g.setColor(this.trailingDayForeground);
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        FontMetrics fm = g.getFontMetrics();
        g.drawString(numericDay, this.isLeftToRight ? x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay) : x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay) - 1, y + boxPaddingY + fm.getAscent());
    }

    protected void paintBackground(Rectangle clip, Graphics g) {
        if (this.monthView.isOpaque()) {
            g.setColor(this.monthView.getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
    }

    private void traverseMonth(int arrowType) {
        if (arrowType == 1) {
            this.previousMonth();
        } else if (arrowType == 2) {
            this.nextMonth();
        }
    }

    private void nextMonth() {
        Date upperBound = this.monthView.getUpperBound();
        if (upperBound == null || upperBound.after(this.getLastDisplayedDay())) {
            Calendar cal = this.getCalendar();
            cal.add(2, 1);
            this.monthView.setFirstDisplayedDay(cal.getTime());
        }
    }

    private void previousMonth() {
        Date lowerBound = this.monthView.getLowerBound();
        if (lowerBound == null || lowerBound.before(this.getFirstDisplayedDay())) {
            Calendar cal = this.getCalendar();
            cal.add(2, -1);
            this.monthView.setFirstDisplayedDay(cal.getTime());
        }
    }

    protected Calendar getCalendar() {
        return this.getCalendar(this.getFirstDisplayedDay());
    }

    protected Calendar getCalendar(Date date) {
        Calendar calendar = this.monthView.getCalendar();
        calendar.setTime(date);
        return calendar;
    }

    private void updateLastDisplayedDay(Date first) {
        Calendar cal = this.getCalendar(first);
        cal.add(2, this.calendarColumnCount * this.calendarRowCount - 1);
        CalendarUtils.endOfMonth(cal);
        this.lastDisplayedDate = cal.getTime();
    }

    @Override
    public Date getLastDisplayedDay() {
        return this.lastDisplayedDate;
    }

    protected void setFirstDisplayedDay(Date firstDisplayedDate) {
        Calendar calendar = this.getCalendar(firstDisplayedDate);
        this.firstDisplayedDate = firstDisplayedDate;
        this.firstDisplayedMonth = calendar.get(2);
        this.firstDisplayedYear = calendar.get(1);
        this.updateLastDisplayedDay(firstDisplayedDate);
        this.monthView.repaint();
    }

    protected Date getFirstDisplayedDay() {
        return this.firstDisplayedDate;
    }

    protected int getFirstDisplayedMonth() {
        return this.firstDisplayedMonth;
    }

    protected int getFirstDisplayedYear() {
        return this.firstDisplayedYear;
    }

    protected SortedSet<Date> getSelection() {
        return this.monthView.getSelection();
    }

    protected Date getToday() {
        return this.monthView.getToday();
    }

    protected boolean isToday(Date date) {
        return date.equals(this.getToday());
    }

    private boolean canSelectByMode() {
        return true;
    }

    @Deprecated
    private void calculateStartPositionUnused() {
        int width = this.monthView.getWidth();
        this.startX = (width - this.calculateCalendarGridWidth()) / 2;
        if (!this.isLeftToRight) {
            this.startX = width - this.startX;
        }
        this.startY = this.calculateCalendarGridY();
    }

    private class KeyboardAction
    extends AbstractAction {
        public static final int ACCEPT_SELECTION = 0;
        public static final int CANCEL_SELECTION = 1;
        public static final int SELECT_PREVIOUS_DAY = 2;
        public static final int SELECT_NEXT_DAY = 3;
        public static final int SELECT_DAY_PREVIOUS_WEEK = 4;
        public static final int SELECT_DAY_NEXT_WEEK = 5;
        public static final int ADJUST_SELECTION_PREVIOUS_DAY = 6;
        public static final int ADJUST_SELECTION_NEXT_DAY = 7;
        public static final int ADJUST_SELECTION_PREVIOUS_WEEK = 8;
        public static final int ADJUST_SELECTION_NEXT_WEEK = 9;
        private int action;

        public KeyboardAction(int action) {
            this.action = action;
        }

        public void actionPerformed(ActionEvent ev) {
            if (!BasicMonthViewUI.this.canSelectByMode()) {
                return;
            }
            if (!BasicMonthViewUI.this.isUsingKeyboard()) {
                BasicMonthViewUI.this.originalDateSpan = BasicMonthViewUI.this.getSelection();
            }
            if (this.action >= 0 && this.action <= 1) {
                if (this.action == 1) {
                    if (BasicMonthViewUI.this.originalDateSpan != null && !BasicMonthViewUI.this.originalDateSpan.isEmpty()) {
                        BasicMonthViewUI.this.monthView.setSelectionInterval((Date)BasicMonthViewUI.this.originalDateSpan.first(), (Date)BasicMonthViewUI.this.originalDateSpan.last());
                    } else {
                        BasicMonthViewUI.this.monthView.clearSelection();
                    }
                    BasicMonthViewUI.this.monthView.cancelSelection();
                } else {
                    BasicMonthViewUI.this.monthView.commitSelection();
                }
                BasicMonthViewUI.this.setUsingKeyboard(false);
            } else if (this.action >= 2 && this.action <= 5) {
                BasicMonthViewUI.this.setUsingKeyboard(true);
                BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
                BasicMonthViewUI.this.pivotDate = null;
                this.traverse(this.action);
            } else if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.SINGLE_INTERVAL_SELECTION && this.action >= 6 && this.action <= 9) {
                BasicMonthViewUI.this.setUsingKeyboard(true);
                BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
                this.addToSelection(this.action);
            }
        }

        private void traverse(int action) {
            Date oldStart = BasicMonthViewUI.this.monthView.isSelectionEmpty() ? BasicMonthViewUI.this.monthView.getToday() : BasicMonthViewUI.this.monthView.getFirstSelectionDate();
            Calendar cal = BasicMonthViewUI.this.getCalendar(oldStart);
            switch (action) {
                case 2: {
                    cal.add(5, -1);
                    break;
                }
                case 3: {
                    cal.add(5, 1);
                    break;
                }
                case 4: {
                    cal.add(5, -7);
                    break;
                }
                case 5: {
                    cal.add(5, 7);
                }
            }
            Date newStartDate = cal.getTime();
            if (!newStartDate.equals(oldStart)) {
                BasicMonthViewUI.this.monthView.setSelectionInterval(newStartDate, newStartDate);
                BasicMonthViewUI.this.monthView.ensureDateVisible(newStartDate);
            }
        }

        private void addToSelection(int action) {
            Date newEndDate;
            Date selectionEnd;
            Date newStartDate;
            Date selectionStart;
            if (!BasicMonthViewUI.this.monthView.isSelectionEmpty()) {
                newStartDate = selectionStart = BasicMonthViewUI.this.monthView.getFirstSelectionDate();
                newEndDate = selectionEnd = BasicMonthViewUI.this.monthView.getLastSelectionDate();
            } else {
                newEndDate = selectionEnd = (newStartDate = (selectionStart = BasicMonthViewUI.this.monthView.getToday()));
            }
            if (BasicMonthViewUI.this.pivotDate == null) {
                BasicMonthViewUI.this.pivotDate = newStartDate;
            }
            boolean isForward = true;
            Calendar cal = BasicMonthViewUI.this.getCalendar();
            switch (action) {
                case 6: {
                    if (!newEndDate.after(BasicMonthViewUI.this.pivotDate)) {
                        cal.setTime(newStartDate);
                        cal.add(5, -1);
                        newStartDate = cal.getTime();
                    } else {
                        cal.setTime(newEndDate);
                        cal.add(5, -1);
                        newEndDate = cal.getTime();
                    }
                    isForward = false;
                    break;
                }
                case 7: {
                    if (!newStartDate.before(BasicMonthViewUI.this.pivotDate)) {
                        cal.setTime(newEndDate);
                        cal.add(5, 1);
                        newStartDate = BasicMonthViewUI.this.pivotDate;
                        newEndDate = cal.getTime();
                        break;
                    }
                    cal.setTime(newStartDate);
                    cal.add(5, 1);
                    newStartDate = cal.getTime();
                    break;
                }
                case 8: {
                    if (!newEndDate.after(BasicMonthViewUI.this.pivotDate)) {
                        cal.setTime(newStartDate);
                        cal.add(5, -7);
                        newStartDate = cal.getTime();
                    } else {
                        cal.setTime(newEndDate);
                        cal.add(5, -7);
                        Date newTime = cal.getTime();
                        if (!newTime.after(BasicMonthViewUI.this.pivotDate)) {
                            newStartDate = newTime;
                            newEndDate = BasicMonthViewUI.this.pivotDate;
                        } else {
                            newEndDate = cal.getTime();
                        }
                    }
                    isForward = false;
                    break;
                }
                case 9: {
                    if (!newStartDate.before(BasicMonthViewUI.this.pivotDate)) {
                        cal.setTime(newEndDate);
                        cal.add(5, 7);
                        newEndDate = cal.getTime();
                        break;
                    }
                    cal.setTime(newStartDate);
                    cal.add(5, 7);
                    Date newTime = cal.getTime();
                    if (!newTime.before(BasicMonthViewUI.this.pivotDate)) {
                        newStartDate = BasicMonthViewUI.this.pivotDate;
                        newEndDate = newTime;
                        break;
                    }
                    newStartDate = cal.getTime();
                }
            }
            if (!newStartDate.equals(selectionStart) || !newEndDate.equals(selectionEnd)) {
                BasicMonthViewUI.this.monthView.setSelectionInterval(newStartDate, newEndDate);
                BasicMonthViewUI.this.monthView.ensureDateVisible(isForward ? newEndDate : newStartDate);
            }
        }
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener,
    LayoutManager,
    PropertyChangeListener,
    DateSelectionListener {
        private boolean armed;
        private Date startDate;
        private Date endDate;
        private Dimension preferredSize = new Dimension();

        private Handler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            int arrowType;
            BasicMonthViewUI.this.setUsingKeyboard(false);
            if (!BasicMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            if (!BasicMonthViewUI.this.monthView.hasFocus() && BasicMonthViewUI.this.monthView.isFocusable()) {
                BasicMonthViewUI.this.monthView.requestFocusInWindow();
            }
            if (BasicMonthViewUI.this.monthView.isTraversable() && (arrowType = BasicMonthViewUI.this.getTraversableGridPositionAtLocation(e.getX(), e.getY())) != -1) {
                BasicMonthViewUI.this.traverseMonth(arrowType);
                return;
            }
            if (!BasicMonthViewUI.this.canSelectByMode()) {
                return;
            }
            Date cal = BasicMonthViewUI.this.getDayAtLocation(e.getX(), e.getY());
            if (cal == null) {
                return;
            }
            this.startDate = cal;
            this.endDate = cal;
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.SINGLE_INTERVAL_SELECTION || BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION) {
                BasicMonthViewUI.this.pivotDate = this.startDate;
            }
            BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION && e.isControlDown()) {
                BasicMonthViewUI.this.monthView.addSelectionInterval(this.startDate, this.endDate);
            } else {
                BasicMonthViewUI.this.monthView.setSelectionInterval(this.startDate, this.endDate);
            }
            this.armed = true;
        }

        public void mouseReleased(MouseEvent e) {
            BasicMonthViewUI.this.setUsingKeyboard(false);
            if (!BasicMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            if (!BasicMonthViewUI.this.monthView.hasFocus() && BasicMonthViewUI.this.monthView.isFocusable()) {
                BasicMonthViewUI.this.monthView.requestFocusInWindow();
            }
            if (this.armed) {
                BasicMonthViewUI.this.monthView.commitSelection();
            }
            this.armed = false;
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            BasicMonthViewUI.this.setUsingKeyboard(false);
            if (!BasicMonthViewUI.this.monthView.isEnabled() || !BasicMonthViewUI.this.canSelectByMode()) {
                return;
            }
            Date cal = BasicMonthViewUI.this.getDayAtLocation(e.getX(), e.getY());
            if (cal == null) {
                return;
            }
            Date selected = cal;
            Date oldStart = this.startDate;
            Date oldEnd = this.endDate;
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.SINGLE_SELECTION) {
                if (selected.equals(oldStart)) {
                    return;
                }
                this.startDate = selected;
                this.endDate = selected;
            } else if (selected.before(BasicMonthViewUI.this.pivotDate)) {
                this.startDate = selected;
                this.endDate = BasicMonthViewUI.this.pivotDate;
            } else if (selected.after(BasicMonthViewUI.this.pivotDate)) {
                this.startDate = BasicMonthViewUI.this.pivotDate;
                this.endDate = selected;
            }
            if (this.startDate.equals(oldStart) && this.endDate.equals(oldEnd)) {
                return;
            }
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION && e.isControlDown()) {
                BasicMonthViewUI.this.monthView.addSelectionInterval(this.startDate, this.endDate);
            } else {
                BasicMonthViewUI.this.monthView.setSelectionInterval(this.startDate, this.endDate);
            }
            this.armed = true;
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return new Dimension(this.preferredSize);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            int newHeight;
            int val;
            String[] daysOfTheWeek;
            int currWidth;
            int longestMonth = 0;
            int daysInLongestMonth = 0;
            int longestMonthWidth = 0;
            FontMetrics fm = BasicMonthViewUI.this.monthView.getFontMetrics(BasicMonthViewUI.this.derivedFont);
            Calendar cal = BasicMonthViewUI.this.getCalendar();
            cal.set(2, cal.getMinimum(2));
            cal.set(5, cal.getActualMinimum(5));
            for (int i = 0; i < cal.getMaximum(2); ++i) {
                int currDays;
                currWidth = fm.stringWidth(BasicMonthViewUI.this.monthsOfTheYear[i]);
                if (currWidth > longestMonthWidth) {
                    longestMonthWidth = currWidth;
                }
                if ((currDays = cal.getActualMaximum(5)) > daysInLongestMonth) {
                    longestMonth = cal.get(2);
                    daysInLongestMonth = currDays;
                }
                cal.add(2, 1);
            }
            BasicMonthViewUI.this.boxHeight = fm.getHeight();
            for (String dayOfTheWeek : daysOfTheWeek = BasicMonthViewUI.this.monthView.getDaysOfTheWeek()) {
                currWidth = fm.stringWidth(dayOfTheWeek);
                if (currWidth <= BasicMonthViewUI.this.boxWidth) continue;
                BasicMonthViewUI.this.boxWidth = currWidth;
            }
            cal.set(2, longestMonth);
            cal.set(5, cal.getActualMinimum(5));
            for (int i = 0; i < daysInLongestMonth; ++i) {
                currWidth = fm.stringWidth(BasicMonthViewUI.this.dayOfMonthFormatter.format(cal.getTime()));
                if (currWidth > BasicMonthViewUI.this.boxWidth) {
                    BasicMonthViewUI.this.boxWidth = currWidth;
                }
                cal.add(5, 1);
            }
            boolean showingWeekNumber = BasicMonthViewUI.this.monthView.isShowingWeekNumber();
            if (showingWeekNumber && (currWidth = fm.stringWidth(Integer.toString(val = cal.getActualMaximum(3)))) > BasicMonthViewUI.this.boxWidth) {
                BasicMonthViewUI.this.boxWidth = currWidth;
            }
            BasicMonthViewUI.this.monthBoxHeight = BasicMonthViewUI.this.boxHeight;
            if (BasicMonthViewUI.this.monthView.isTraversable() && (newHeight = BasicMonthViewUI.this.monthDownImage.getIconHeight() + BasicMonthViewUI.this.arrowPaddingY + BasicMonthViewUI.this.arrowPaddingY) > BasicMonthViewUI.this.monthBoxHeight) {
                BasicMonthViewUI.this.monthBoxHeight = newHeight;
            }
            int boxPaddingX = BasicMonthViewUI.this.monthView.getBoxPaddingX();
            int boxPaddingY = BasicMonthViewUI.this.monthView.getBoxPaddingY();
            this.preferredSize.width = (BasicMonthViewUI.this.boxWidth + 2 * boxPaddingX) * 7;
            if (this.preferredSize.width < longestMonthWidth) {
                double diff = longestMonthWidth - this.preferredSize.width;
                if (BasicMonthViewUI.this.monthView.isTraversable()) {
                    diff += (double)(BasicMonthViewUI.this.monthDownImage.getIconWidth() + BasicMonthViewUI.this.monthUpImage.getIconWidth() + BasicMonthViewUI.this.arrowPaddingX * 4);
                }
                BasicMonthViewUI.this.boxWidth = (int)((double)BasicMonthViewUI.this.boxWidth + Math.ceil(diff / 7.0));
            }
            BasicMonthViewUI.this.fullBoxWidth = BasicMonthViewUI.this.boxWidth + boxPaddingX + boxPaddingX;
            BasicMonthViewUI.this.fullBoxHeight = BasicMonthViewUI.this.boxHeight + boxPaddingY + boxPaddingY;
            BasicMonthViewUI.this.fullMonthBoxHeight = BasicMonthViewUI.this.monthBoxHeight + boxPaddingY + boxPaddingY;
            BasicMonthViewUI.this.calendarWidth = BasicMonthViewUI.this.fullBoxWidth * 7;
            if (showingWeekNumber) {
                BasicMonthViewUI.this.calendarWidth += BasicMonthViewUI.this.fullBoxWidth;
            }
            BasicMonthViewUI.this.fullCalendarWidth = BasicMonthViewUI.this.calendarWidth + 10;
            BasicMonthViewUI.this.calendarHeight = BasicMonthViewUI.this.fullBoxHeight * 7 + BasicMonthViewUI.this.fullMonthBoxHeight;
            BasicMonthViewUI.this.fullCalendarHeight = BasicMonthViewUI.this.calendarHeight + 10;
            int prefRows = BasicMonthViewUI.this.monthView.getPreferredRows();
            this.preferredSize.height = BasicMonthViewUI.this.calendarHeight * prefRows + 10 * (prefRows - 1);
            int prefCols = BasicMonthViewUI.this.monthView.getPreferredCols();
            this.preferredSize.width = BasicMonthViewUI.this.calendarWidth * prefCols + 10 * (prefCols - 1);
            Insets insets = BasicMonthViewUI.this.monthView.getInsets();
            this.preferredSize.width += insets.left + insets.right;
            this.preferredSize.height += insets.top + insets.bottom;
            BasicMonthViewUI.this.calculateMonthGridLayoutProperties();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if ("componentOrientation".equals(property)) {
                BasicMonthViewUI.this.isLeftToRight = BasicMonthViewUI.this.monthView.getComponentOrientation().isLeftToRight();
                BasicMonthViewUI.this.monthView.revalidate();
            } else if ("selectionModel".equals(property)) {
                DateSelectionModel selectionModel = (DateSelectionModel)evt.getOldValue();
                selectionModel.removeDateSelectionListener(BasicMonthViewUI.this.getHandler());
                selectionModel = (DateSelectionModel)evt.getNewValue();
                selectionModel.addDateSelectionListener(BasicMonthViewUI.this.getHandler());
            } else if ("firstDisplayedDay".equals(property)) {
                BasicMonthViewUI.this.setFirstDisplayedDay((Date)evt.getNewValue());
            } else if ("boxPaddingX".equals(property) || "boxPaddingY".equals(property) || "traversable".equals(property) || "daysOfTheWeek".equals(property) || "border".equals(property) || "showingWeekNumber".equals(property) || "traversable".equals(property)) {
                BasicMonthViewUI.this.monthView.revalidate();
                BasicMonthViewUI.this.monthView.repaint();
            } else if ("font".equals(property)) {
                BasicMonthViewUI.this.derivedFont = BasicMonthViewUI.this.createDerivedFont();
                BasicMonthViewUI.this.monthView.revalidate();
            } else if ("componentInputMapEnabled".equals(property)) {
                BasicMonthViewUI.this.updateComponentInputMap();
            } else if ("locale".equals(property)) {
                BasicMonthViewUI.this.updateLocale();
            } else if ("timeZone".equals(property)) {
                BasicMonthViewUI.this.dayOfMonthFormatter.setTimeZone((TimeZone)evt.getNewValue());
            } else if ("flaggedDates".equals(property) || "showingTrailingDays".equals(property) || "showingLeadingDays".equals(property) || "today".equals(property) || "antialiased".equals(property)) {
                BasicMonthViewUI.this.monthView.repaint();
            }
        }

        public void valueChanged(DateSelectionEvent ev) {
            BasicMonthViewUI.this.monthView.repaint();
        }
    }
}

