% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTWAPLS.R
\name{cv.pr.w}
\alias{cv.pr.w}
\title{Pseudo-removed leave-out cross-validation}
\usage{
cv.pr.w(
  modern_taxa,
  modern_climate,
  nPLS = 5,
  trainfun,
  predictfun,
  pseudo,
  usefx = FALSE,
  fx = NA,
  cpus = 4,
  test_mode = TRUE,
  test_it = 5
)
}
\arguments{
\item{modern_taxa}{the modern taxa abundance data, each row represents a
sampling site, each column represents a taxon.}

\item{modern_climate}{the modern climate value at each sampling site}

\item{nPLS}{the number of components to be extracted}

\item{trainfun}{training function you want to use, either
\code{\link{WAPLS.w}} or \code{\link{TWAPLS.w}}}

\item{predictfun}{predict function you want to use: if \code{trainfun} is
\code{\link{WAPLS.w}}, then this should be \code{\link{WAPLS.predict.w}};
if \code{trainfun} is \code{\link{TWAPLS.w}}, then this should be
\code{\link{TWAPLS.predict.w}}}

\item{pseudo}{the geographically and climatically close sites to each test
site, obtained from \code{\link{get_pseudo}} function}

\item{usefx}{boolean flag on whether or not use \code{fx} correction.}

\item{fx}{the frequency of the climate value for \code{fx} correction: if
\code{usefx} is FALSE, this should be \code{NA}; otherwise, this should
be obtained from the \code{\link{fx}} function.}

\item{cpus}{number of CPUs for simultaneous iterations to execute, check
\code{parallel::detectCores()} for available CPUs on your machine.}

\item{test_mode}{boolean flag to execute the function with a limited number
of iterations, \code{test_it}, for testing purposes only.}

\item{test_it}{number of iterations to use in the test mode}
}
\value{
leave-one-out cross validation results
}
\description{
Pseudo-removed leave-out cross-validation
}
\examples{
\dontrun{
# Load modern pollen data
modern_pollen <- read.csv("/path/to/modern_pollen.csv")
                                      
# Extract taxa
taxaColMin <- which(colnames(modern_pollen) == "taxa0")
taxaColMax <- which(colnames(modern_pollen) == "taxaN")
taxa <- modern_pollen[, taxaColMin:taxaColMax]

point <- modern_pollen[, c("Long", "Lat")]
test_mode <- TRUE # It should be set to FALSE before running
dist <- fxTWAPLS::get_distance(point, 
                               cpus = 2, # Remove the following line
                               test_mode = test_mode)
pseudo_Tmin <- fxTWAPLS::get_pseudo(dist, 
                                    modern_pollen$Tmin, 
                                    cpus = 2, # Remove the following line
                                    test_mode = test_mode)
# Test WAPLS
cv_pr_Tmin <- fxTWAPLS::cv.pr.w(taxa,
                                modern_pollen$Tmin,
                                nPLS = 5,
                                fxTWAPLS::TWAPLS.w,
                                fxTWAPLS::TWAPLS.predict.w,
                                pseudo_Tmin,
                                cpus = 2, # Remove the following line
                                test_mode = test_mode)
# Test TWAPLS
cv_pr_t_Tmin <- fxTWAPLS::cv.pr.w(taxa,
                                  modern_pollen$Tmin,
                                  nPLS = 5,
                                  fxTWAPLS::TWAPLS.w,
                                  fxTWAPLS::TWAPLS.predict.w,
                                  pseudo_Tmin,
                                  cpus = 2, # Remove the following line
                                  test_mode = test_mode)
}

}
\seealso{
\code{\link{fx}}, \code{\link{TWAPLS.w}},
\code{\link{TWAPLS.predict.w}}, \code{\link{WAPLS.w}}, and
\code{\link{WAPLS.predict.w}}
}
