% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{par_benchmark}
\alias{par_benchmark}
\title{Perform parallel benchmarks on a function}
\usage{
par_benchmark(CPUS, FUN, plot = FALSE, quiet = FALSE, ...)
}
\arguments{
\item{CPUS}{vector with the number of CPUs}

\item{FUN}{parallel function, MUST have a parameter called \code{cpus}}

\item{plot}{boolean flag to request a plot for the results}

\item{quiet}{boolean flag to print results of each execution}

\item{...}{optional arguments for the function, must be named; e.g.
\code{x = test_df}}
}
\description{
Perform parallel benchmarks on a function
}
\examples{
# Define toy function that sleeps for (2/cpus) seconds
a <- function(cpus) {Sys.sleep(2/cpus)}
par_benchmark(c(1, 2), a)
\donttest{
par_benchmark(c(1, 2), a, plot = TRUE)
}
}
