test_that("errors and warnings q = 1", {

  skip_on_cran()
  
  # ------------------------------------------------------------------ #
  # test for warnings and errors
  # ------------------------------------------------------------------ #
  library(fwildclusterboot)
  library(fixest)
  library(lfe)


  for (boot_algo in c("R", "WildBootTests.jl", "R-lean")) {
    cat(boot_algo, "\n")

    # for(boot_algo in c("R-lean")){
    # test boottest function arguments for errors
    lm_fit <- lm(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
      data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
    )
    feols_fit <- feols(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
      data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
    )
    felm_fit <- felm(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
      data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
    )
    feols_fit_c <- feols(proposition_vote ~ treatment + ideology1 + log_income | Q1_immigration,
      data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
    )
    felm_fit_c <- felm(proposition_vote ~ treatment + ideology1 + log_income | Q1_immigration,
      data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
    )

    # sign_level
    expect_error(boottest(
      object = lm_fit, clustid = "group_id1", B = 999, seed = 911, param = "treatment", conf_int = TRUE,
      sign_level = 1.1,
      boot_algo = boot_algo
    ))
    expect_error(boottest(
      object = feols_fit, clustid = c("group_id1"), B = 999, seed = 911, param = "treatment", conf_int = TRUE,
      sign_level = 1.1,
      boot_algo = boot_algo
    ))
    expect_error(boottest(
      object = felm_fit, clustid = "group_id1", B = 999, seed = 911, param = "treatment", conf_int = TRUE,
      sign_level = 1.1,
      boot_algo = boot_algo
    ))
    expect_error(boottest(
      object = lm_fit, clustid = "group_id1", B = 999, seed = 911, param = "treatment", conf_int = TRUE,
      sign_level = -1.1,
      boot_algo = boot_algo
    ))
    expect_error(boottest(
      object = feols_fit, clustid = c("group_id1"), B = 999, seed = 911, param = "treatment", conf_int = TRUE,
      sign_level = -1.1,
      boot_algo = boot_algo
    ))
    expect_error(boottest(
      object = felm_fit, clustid = "group_id1", B = 999, seed = 911, param = "treatment", conf_int = TRUE,
      sign_level = -1.1,
      boot_algo = boot_algo
    ))

    # B < 100
    if (boot_algo %in% c("R", "R-lean")) {
      expect_error(boottest(object = lm_fit, clustid = "group_id1", B = 99, seed = 911, param = "treatment", conf_int = TRUE, boot_algo = boot_algo))
      expect_error(boottest(object = feols_fit, clustid = c("group_id1"), B = 99, seed = 911, param = "treatment", conf_int = TRUE, boot_algo = boot_algo))
      expect_error(boottest(object = felm_fit, clustid = "group_id1", B = 99, seed = 911, param = "treatment", conf_int = TRUE, boot_algo = boot_algo))
    }

    # param not in data.frame
    expect_error(boottest(object = lm_fit, clustid = "group_id1", B = 999, seed = 911, param = "treatment1", conf_int = TRUE, boot_algo = boot_algo))
    expect_error(boottest(object = feols_fit, clustid = c("group_id1"), B = 999, seed = 911, param = "treatment1", conf_int = TRUE, boot_algo = boot_algo))
    expect_error(boottest(object = felm_fit, clustid = "group_id1", B = 999, seed = 911, param = "treatment1", conf_int = TRUE, boot_algo = boot_algo))

    # rademacher enumeration case
    if (boot_algo != "R-lean") {
      suppressWarnings(expect_warning(boottest(object = lm_fit, clustid = "group_id1", B = 9999, seed = 911, param = "treatment", conf_int = TRUE, boot_algo = boot_algo)))
      suppressWarnings(expect_warning(boottest(object = feols_fit, clustid = c("group_id1"), B = 9999, seed = 911, param = "treatment", conf_int = TRUE, boot_algo = boot_algo)))
      suppressWarnings(expect_warning(boottest(object = felm_fit, clustid = "group_id1", B = 9999, seed = 911, param = "treatment", conf_int = TRUE, boot_algo = boot_algo)))
    }

    suppressWarnings(expect_warning(boottest(object = lm_fit, clustid = "group_id1", B = 2^10, seed = 911, param = "treatment", conf_int = TRUE, boot_algo = boot_algo)))

    # expect_warning(boottest(object = lm_fit, clustid =  "group_id1", B = 9999, seed = 911, param = "treatment", conf_int = TRUE, type = "mammen"))
    # expect_warning(boottest(object = feols_fit, clustid = c("group_id1"), B = 9999, seed = 911, param = "treatment", conf_int = TRUE, type = "mammen"))
    # expect_warning(boottest(object = felm_fit, clustid =  "group_id1", B = 9999, seed = 911, param = "treatment", conf_int = TRUE, type = "mammen"))


    # test for banned function arguments and syntax for fixest
    feols_fit <- feols(proposition_vote ~ treatment + ideology1 + i(log_income, Q1_immigration),
      data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
    )
    expect_error(boottest(object = feols_fit, clustid = c("group_id1"), B = 999, seed = 911, param = "treatment1", conf_int = TRUE, boot_algo = boot_algo))

    feols_fit <- feols(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
      weights = fwildclusterboot:::create_data(N = 10000, N_G1 = 20, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)$weights,
      data = fwildclusterboot:::create_data(N = 10000, N_G1 = 20, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
    )
    felm_fit <- felm(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
      weights = fwildclusterboot:::create_data(N = 10000, N_G1 = 20, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)$weights,
      data = fwildclusterboot:::create_data(N = 10000, N_G1 = 20, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
    )

    # joint fe != NULL and weights = on
    if (boot_algo %in% c("R", "R-lean")) {
      expect_error(boottest(object = felm_fit, clustid = "group_id1", B = 999, seed = 911, param = "treatment", conf_int = TRUE, fe = "Q1_immigration", boot_algo = boot_algo))
      expect_error(boottest(object = feols_fit, clustid = c("group_id1"), B = 999, seed = 911, param = "treatment", conf_int = TRUE, fe = "Q1_immigration", boot_algo = boot_algo))
    }

    # nthreads < 1

    expect_error(boottest(
      object = lm_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      nthreads = -1,
      boot_algo = boot_algo
    ))

    # expect_warning(boottest(object = lm_fit,
    #                       clustid =  "group_id1",
    #                       B = 999, seed = 911,
    #                       ,
    #                       conf_int = TRUE,
    #                       nthreads = 20))

    # Warning: In boottest.lm(object = lm_fit, clustid = "group_id1...:
    # Asked for 20 threads while the maximum is 8. Set to 8 threads instead.
    # will probably not run on cran, as max 2 cores

    expect_error(boottest(
      object = feols_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      nthreads = -1,
      boot_algo = boot_algo
    ))
    # expect_warning(boottest(object = feols_fit,
    #                       clustid =  "group_id1",
    #                       B = 999, seed = 911,
    #                       ,
    #                       conf_int = TRUE,
    #                       nthreads = 20))

    expect_error(boottest(
      object = felm_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      nthreads = -1,
      boot_algo = boot_algo
    ))

    # expect_warning(boottest(object = felm_fit,
    #                       clustid =  "group_id1",
    #                       B = 999, seed = 911,
    #                       ,
    #                       conf_int = TRUE,
    #                       nthreads = 20))

    # maxiter
    expect_error(boottest(
      object = lm_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      maxiter = -1,
      boot_algo = boot_algo
    ))
    expect_error(boottest(
      object = lm_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      maxiter = 0.1,
      boot_algo = boot_algo
    ))

    expect_error(boottest(
      object = feols_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      maxiter = -1,
      boot_algo = boot_algo
    ))
    expect_error(boottest(
      object = feols_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      maxiter = 0.1,
      boot_algo = boot_algo
    ))

    expect_error(boottest(
      object = felm_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      maxiter = -1,
      boot_algo = boot_algo
    ))
    expect_error(boottest(
      object = felm_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      maxiter = 0.1,
      boot_algo = boot_algo
    ))


    # tol
    expect_error(boottest(
      object = lm_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      tol = -1, boot_algo = boot_algo
    ))

    expect_error(boottest(
      object = feols_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      tol = -1, boot_algo = boot_algo
    ))

    expect_error(boottest(
      object = felm_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      tol = -1, boot_algo = boot_algo
    ))

    # p-val type
    expect_error(boottest(
      object = lm_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      p_val_type = "equaltail", boot_algo = boot_algo
    ))

    expect_error(boottest(
      object = feols_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      p_val_type = "equaltail", boot_algo = boot_algo
    ))

    expect_error(boottest(
      object = felm_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      p_val_type = "equaltail", boot_algo = boot_algo
    ))

    # B = 1000
    suppressWarnings(expect_message(boottest(
      object = lm_fit,
      clustid = "group_id1",
      B = 1000, seed = 911,
      param = "treatment",
      conf_int = TRUE,
      boot_algo = boot_algo
    )))

    if(boot_algo != "R-lean"){
      suppressWarnings(expect_message(boottest(
        object = feols_fit,
        clustid = "group_id1",
        B = 1000,
        seed = 911,
        param = "treatment",
        conf_int = TRUE,
        boot_algo = boot_algo
      )))
      
      suppressWarnings(expect_message(boottest(
        object = felm_fit,
        clustid = "group_id1",
        B = 1000, seed = 911,
        param = "treatment",
        conf_int = TRUE, boot_algo = boot_algo
      )))
    }

    # banned function arguments


    # 1) felm
    felm_fit <- felm(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
      data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234),
      subset = sample(c(TRUE, FALSE), 1000, TRUE)
    )
    expect_error(boottest(
      object = felm_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE, boot_algo = boot_algo
    ))

    # 2) lm
    lm_fit <- lm(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
      data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234),
      subset = sample(c(TRUE, FALSE), 1000, TRUE)
    )
    expect_error(boottest(
      object = lm_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE, boot_algo = boot_algo
    ))

    # fixest
    feols_fit <- feols(proposition_vote ~ treatment + ideology1 + i(log_income, Q1_immigration),
      data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
    )
    expect_error(boottest(
      object = feols_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE, boot_algo = boot_algo
    ))
    feols_fit <- feols(proposition_vote ~ treatment + ideology1,
      data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234),
      subset = sample(c(TRUE, FALSE), 1000, TRUE)
    )
    expect_error(boottest(
      object = feols_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE, boot_algo = boot_algo
    ))

    feols_fit <- feols(proposition_vote ~ treatment + ideology1 | Q1_immigration^Q2_defense,
                       data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234),
                       subset = sample(c(TRUE, FALSE), 1000, TRUE)
    )
    expect_error(boottest(
      object = feols_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      param = "treatment",
      conf_int = TRUE, 
      boot_algo = boot_algo
    ))

    
    
    # evalute dots ... in methods
    # write sig_level instead of sign_level
    expect_error(boottest(
      object = lm_fit, clustid = "group_id1", B = 999, seed = 911, param = "treatment", conf_int = TRUE,
      sig_level = 0.1, boot_algo = boot_algo
    ))
    expect_error(boottest(
      object = feols_fit, clustid = "group_id1", B = 999, seed = 911, param = "treatment", conf_int = TRUE,
      sig_level = 0.1, boot_algo = boot_algo
    ))
    expect_error(boottest(
      object = felm_fit, clustid = "group_id1", B = 999, seed = 911, param = "treatment", conf_int = TRUE,
      sig_level = 0.1, boot_algo = boot_algo
    ))

    lm_fit <- lm(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
      data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
    )

    res <- boottest(lm_fit,
      clustid = "group_id1", B = 999, seed = 911, param = "treatment", conf_int = TRUE,
      sign_level = 0.1, boot_algo = boot_algo
    )

    expect_error(summary(res, a = 1))
    # expect_error(tidy(res, a = 1))
    expect_error(plot(res, a = 1))




    # if 2^(number of clusters) < B and rademacher or mammen weights are used, boottest() switches
    # to full enumeration. In consequence, only 2^(number of clusters - 1) unique t statistics can be computed (see Webb, "Reworking wild bootstrap based inference for clustered errors", 2013)
    # This will cause trouble for the inversion of p-values, for two reasons: a) the p-value function will not
    # be sufficiently smooth b) no appropriate starting value for the root finding procedure will be found
    # this set of tests checks if boottest() throws an error in the part of the code that is responsible for
    # calculating p-values

    lm_fit <- lm(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
      data = fwildclusterboot:::create_data(N = 100, N_G1 = 4, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1)
    )

    # no confidence intervals calculated: expect warning
    expect_warning(
      boottest(
        object = lm_fit,
        clustid = "group_id1",
        # guarantees that full enumeration is employed
        B = 2^4 + 1,
        seed = 1,
        param = "treatment",
        type = "rademacher",
        conf_int = FALSE,
        boot_algo = boot_algo
      )
    )



    # with confidence intervals: expect_error because B < 100
    if (boot_algo == "R") {
      expect_error(
        boottest(
          object = lm_fit,
          clustid = "group_id1",
          # guarantees that full enumeration is employed
          B = 2^4 + 1,
          seed = 1,
          param = "treatment",
          type = "rademacher",
          conf_int = TRUE,
          boot_algo = boot_algo
        )
      )
    }


    # with confidence intervals: expect_error because B < 100
    if (boot_algo == "R") {
      expect_error(
        boottest(
          object = lm_fit,
          clustid = "group_id1",
          # guarantees that full enumeration is employed
          B = 2^4 + 1,
          seed = 1,
          param = "treatment",
          type = "mammen",
          conf_int = TRUE,
          boot_algo = boot_algo
        )
      )
    }





    # ------------------------------------------------------------------------- #
    # NA values in the cluster variables
    # ------------------------------------------------------------------------- #

    data <- fwildclusterboot:::create_data(N = 100, N_G1 = 20, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1)
    data[1, "group_id1"] <- NA
    data2 <<- data

    lm_fit <- lm(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
      data = data2
    )

    # expect error as na_omit = FALSE & missing variable in group_id1 (the cluster variable)
    expect_error(
      boottest(
        object = lm_fit,
        clustid = "group_id1",
        # guarantees that full enumeration is employed
        B = 999,
        seed = 1,
        param = "treatment",
        type = "rademacher",
        conf_int = TRUE,
        na_omit = FALSE, boot_algo = boot_algo
      )
    )

    suppressWarnings(expect_warning(
      res <-
        boottest(
          object = lm_fit,
          clustid = "group_id1",
          # guarantees that full enumeration is employed
          B = 999,
          seed = 1,
          param = "treatment",
          type = "rademacher",
          conf_int = TRUE,
          na_omit = TRUE, boot_algo = boot_algo
        )
    ))
    expect_equal(res$N, 99)

    data[2, "group_id1"] <- NA
    data3 <<- data
    lm_fit <- lm(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
      data = data3
    )
    suppressWarnings(expect_warning(
      res <-
        boottest(
          object = lm_fit,
          clustid = "group_id1",
          # guarantees that full enumeration is employed
          B = 999,
          seed = 1,
          param = "treatment",
          type = "rademacher",
          conf_int = TRUE,
          na_omit = TRUE, boot_algo = boot_algo
        )
    ))
    expect_equal(res$N, 98)


    # expect error when length(R) != length(param)

    expect_error(boottest(object = lm_fit, clustid = "group_id1", B = 999, seed = 911, param = c("treatment", "ideology1"), R = 1, conf_int = TRUE, boot_algo = boot_algo))
    expect_error(boottest(object = feols_fit, clustid = c("group_id1"), B = 999, seed = 911, param = c("treatment", "ideology1"), R = 1, conf_int = TRUE, boot_algo = boot_algo))
    expect_error(boottest(object = felm_fit, clustid = "group_id1", B = 999, seed = 911, param = c("treatment", "ideology1"), R = 1, conf_int = TRUE, boot_algo = boot_algo))

    # specify a fixed effect that is also clustering variable OR test variable -> error

    expect_error(boottest(object = feols_fit_c, fe = "Q1_immigration", clustid = c("Q1_immigration"), B = 999, seed = 911, param = c("treatment", "ideology1"), R = 1, conf_int = TRUE, boot_algo = boot_algo))
    expect_error(boottest(object = felm_fit_c, fe = "Q1_immigration", clustid = "Q1_immigration", B = 999, seed = 911, param = c("treatment", "ideology1"), R = 1, conf_int = TRUE, boot_algo = boot_algo))

    expect_error(boottest(object = feols_fit_c, clustid = c("Q1_immigration"), B = 999, seed = 911, param = c("Q1_immigration"), R = 1, conf_int = TRUE, boot_algo = boot_algo))
    expect_error(boottest(object = felm_fit_c, clustid = "Q1_immigration", B = 999, seed = 911, param = c("Q1_immigration"), R = 1, conf_int = TRUE, boot_algo = boot_algo))


    # test for p-val type & conf_int == TRUE (tba)

    # check fixest for deleted singletons. boottest() should throw an error

    base <- iris
    names(base) <- c("y", "x1", "x_endo_1", "x_inst_1", "fe")
    set.seed(2)
    base$x_inst_2 <- 0.2 * base$y + 0.2 * base$x_endo_1 + rnorm(150, sd = 0.5)
    base$x_endo_2 <- 0.2 * base$y - 0.2 * base$x_inst_1 + rnorm(150, sd = 0.5)
    base$clustid <- sample(1:10, nrow(base), TRUE)
    base$clustid[1] <- 11
    base$clustid[2] <- 12
    # unique singletons -> 11, 12

    feols_fit <- feols(y ~ x1 | clustid, base, fixef.rm = "both")
    # lfe::felm - no such behavior
    # felm_fit = felm(y ~ x1 | clustid , base, keepX = TRUE, keepCX = TRUE)
    # dim(felm_fit$X)
    # dim(felm_fit$cX)
    # summary(felm_fit)

    expect_error(boottest(feols_fit, param = "x1", B = 999, clustid = "clustid", boot_algo = boot_algo))


    data <- fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
    weights_vec <- data$weights

    lm_fit <- lm(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
      weights = weights_vec,
      data = data
    )
    feols_fit <- fixest::feols(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
      weights = weights_vec,
      data = data
    )
    lfe_fit <- lfe::felm(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
      weights = weights_vec,
      data = data
    )

    expect_error(boottest(lm_fit, param = "treatment", B = 999, clustid = "clustid", boot_algo = boot_algo))
    expect_error(boottest(feols_fit, param = "treatment", B = 999, clustid = "clustid", boot_algo = boot_algo))
    expect_error(boottest(lfe_fit, param = "treatment", B = 999, clustid = "clustid", boot_algo = boot_algo))


    # param not in clustid, fe
    feols_fit <- fixest::feols(proposition_vote ~ treatment + ideology1 + log_income | Q1_immigration,
      data = data
    )
    lfe_fit <- lfe::felm(proposition_vote ~ treatment + ideology1 + log_income | Q1_immigration,
      data = data
    )

    expect_error(boottest(feols_fit, param = "treatment", fe = "treatment", B = 999, clustid = "group_id1", boot_algo = boot_algo))
    expect_error(boottest(lfe_fit, param = "treatment", fe = "treatment", B = 999, clustid = "group_id1", boot_algo = boot_algo))
    expect_error(boottest(feols_fit, param = "treatment", fe = "Q1_immigration", B = 999, clustid = "Q1_immigration", boot_algo = boot_algo))
    expect_error(boottest(lfe_fit, param = "treatment", fe = "Q1_immigration", B = 999, clustid = "Q1_immigration", boot_algo = boot_algo))



    if (boot_algo %in% c("R", "R-lean")) {

      # R is matrix
      expect_error(boottest(lm_fit, param = "treatment", R = matrix(c(0, 0), 2, 1), fe = "treatment", B = 999, clustid = "group_id1", boot_algo = boot_algo))
      expect_error(boottest(feols_fit, param = "treatment", R = matrix(c(0, 0), 2, 1), fe = "treatment", B = 999, clustid = "group_id1", boot_algo = boot_algo))
      expect_error(boottest(felm_fit, param = "treatment", R = matrix(c(0, 0), 2, 1), fe = "treatment", B = 999, clustid = "group_id1", boot_algo = boot_algo))

      expect_error(boottest(lm_fit, param = "treatment", fe = "treatment", B = 999, clustid = "group_id1", boot_algo = boot_algo, p_val_type = ">", conf_int = TRUE))
      expect_error(boottest(feols_fit, param = "treatment", fe = "treatment", B = 999, clustid = "group_id1", boot_algo = boot_algo, p_val_type = ">", conf_int = TRUE))
      expect_error(boottest(felm_fit, param = "treatment", fe = "treatment", B = 999, clustid = "group_id1", boot_algo = boot_algo, p_val_type = ">", conf_int = TRUE))
    }


    # no support for R-lean with fe = on
    if (boot_algo == "R-lean") {
      feols_fit_c <- feols(proposition_vote ~ treatment + ideology1 + log_income | Q1_immigration,
        data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
      )
      expect_error(boottest(feols_fit_c, param = "treatment", fe = "Q1_immigration", B = 999, clustid = "group_id1", boot_algo = "R-lean"))

      felm_fit_c <- felm(proposition_vote ~ treatment + ideology1 + log_income | Q1_immigration,
        data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
      )
      expect_error(boottest(felm_fit_c, param = "treatment", fe = "Q1_immigration", B = 999, clustid = "group_id1", boot_algo = "R-lean"))
      
      # no support for R-lean with weights
      data1 <<- fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
      lm_fit <- lm(proposition_vote ~ treatment + ideology1 + log_income , weights = data1$weights, 
                         data = data1)
      feols_fit <- feols(proposition_vote ~ treatment + ideology1 + log_income | Q1_immigration, weights = data1$weights, 
                         data = data1)
      felm_fit <- felm(proposition_vote ~ treatment + ideology1 + log_income | Q1_immigration, weights = data1$weights, 
                       data = data1)
      
      expect_error(boottest(lm_fit, param = "treatment", B = 999, clustid = "group_id1", boot_algo = "R-lean"))
      expect_error(boottest(felm_fit, param = "treatment", B = 999, clustid = "group_id1", boot_algo = "R-lean"))
      expect_error(boottest(feols_fit, param = "treatment", B = 999, clustid = "group_id1", boot_algo = "R-lean"))
      
      
    }
  }
})



test_that("error warning IV/WRE and q > 1", {
  
  skip_on_cran()
  
  library(ivreg)
  library(fwildclusterboot)

  # drop all NA values from SchoolingReturns
  SchoolingReturns <- SchoolingReturns[rowMeans(sapply(SchoolingReturns, is.na)) == 0, ]
  ivreg_fit <- ivreg(log(wage) ~ education + age +
    ethnicity + smsa + south + parents14 |
    nearcollege + age + ethnicity + smsa
      + south + parents14,
  data = SchoolingReturns
  )


  # error because invalid param name
  expect_error(
    suppressMessages(
      boottest(
        object = ivreg_fit,
        clustid = "kww",
        B = 999,
        param = "res",
        type = "rademacher",
        conf_int = FALSE
      )
    )
  )

  # error due to length(R) != length(param)
  expect_error(
    suppressMessages(
      boottest(
        object = ivreg_fit,
        clustid = "kww",
        B = 999,
        param = "education",
        R = c(0, 1),
        type = "rademacher",
        conf_int = FALSE
      )
    )
  )

  # forbidden function arguments
  ivreg_fit2 <- ivreg(log(wage) ~ education + age +
    ethnicity + smsa + south + parents14 |
    nearcollege + age + ethnicity + smsa
      + south + parents14,
  data = SchoolingReturns,
  subset = 1:100
  )

  expect_error(
    suppressMessages(
      boottest(
        object = ivreg_fit2,
        clustid = "kww",
        B = 999,
        param = "education",
        type = "rademacher",
        conf_int = FALSE
      )
    )
  )

  # enumeration warning
  expect_warning(
    suppressMessages(
      boottest(
        object = ivreg_fit,
        clustid = "ethnicity",
        B = 999,
        param = "education",
        type = "rademacher",
        conf_int = FALSE
      )
    )
  )
  
  # error when ivreg with other method than OLS
  library(ivreg)
  # drop all NA values from SchoolingReturns
  SchoolingReturns <- SchoolingReturns[rowMeans(sapply(SchoolingReturns, is.na)) == 0, ]
  ivreg_fit <- ivreg(log(wage) ~ education + age +
                       ethnicity + smsa + south + parents14 |
                       nearcollege + age + ethnicity + smsa
                     + south + parents14,
                     data = SchoolingReturns, 
                     method = "M"
  )
  
  expect_error(
    boottest(
      object = ivreg_fit,
      B = 999,
      param = "education",
      clustid = "kww",
      type = "mammen",
      impose_null = TRUE
    )
  )
  
  ivreg_fit <- ivreg(log(wage) ~ education + age +
                       ethnicity + smsa + south + parents14 |
                       nearcollege + age + ethnicity + smsa
                     + south + parents14,
                     data = SchoolingReturns, 
                     subset = 1:1000
  )
  
  expect_error(
    boottest(
      object = ivreg_fit,
      B = 999,
      param = "education",
      clustid = "kww",
      type = "mammen",
      impose_null = TRUE
    )
  )
  
  # bannd args ivreg
  
  # test for banned function arguments and syntax for fixest with mboottest
  feols_fit <- feols(proposition_vote ~ treatment + ideology1 + i(log_income, Q1_immigration),
                     data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
  )
  R <- clubSandwich::constrain_zero(1:2,coef(feols_fit))
  expect_error(mboottest(object = feols_fit, clustid = c("group_id1"), B = 999, seed = 911, R = R))
  
  feols_fit <- feols(proposition_vote ~ treatment + ideology1 ,
                     data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
  )
  R <- clubSandwich::constrain_zero(1:2,coef(feols_fit))
  expect_error(mboottest(object = feols_fit, clustid = c("group_id1"), B = 999, seed = 911, R = R, r = 1:3))
  
  # more mboottest() banned function arguments
  felm_fit <- felm(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
                   data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234),
                   subset = sample(c(TRUE, FALSE), 1000, TRUE)
  )
  expect_error(
    mboottest(
      object = felm_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      R = R
    )
  )
  
  # 2) lm
  lm_fit <- lm(proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
               data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234),
               subset = sample(c(TRUE, FALSE), 1000, TRUE)
  )
  expect_error(mboottest(
    object = lm_fit,
    clustid = "group_id1",
    B = 999, seed = 911,
    R = R
  ))
  
  # fixest
  feols_fit <- feols(proposition_vote ~ treatment + ideology1 + i(log_income, Q1_immigration),
                     data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234)
  )
  expect_error(mboottest(
    object = feols_fit,
    clustid = "group_id1",
    B = 999, seed = 911,
    R = R
  ))
  feols_fit <- feols(proposition_vote ~ treatment + ideology1,
                     data = fwildclusterboot:::create_data(N = 1000, N_G1 = 10, icc1 = 0.01, N_G2 = 10, icc2 = 0.01, numb_fe1 = 10, numb_fe2 = 10, seed = 1234),
                     subset = sample(c(TRUE, FALSE), 1000, TRUE)
  )
  expect_error(
    mboottest(
      object = feols_fit,
      clustid = "group_id1",
      B = 999, seed = 911,
      R = R
    )
  )
  
  
  # check_r_lean
  
  

})



