% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{boottest}
\alias{boottest}
\title{Fast wild cluster bootstrap inference}
\usage{
boottest(object, ...)
}
\arguments{
\item{object}{An object of type lm, fixest of felm}

\item{...}{other arguments}
}
\value{
An object of class \code{boottest}.
}
\description{
\code{boottest} is a S3 method that allows for fast wild cluster
bootstrap inference for objects of class lm, fixest and felm by  implementing
the fast wild bootstrap algorithm developed in Roodman et al., 2019.
}
\references{
Roodman et al., 2019, "Fast and wild: Bootstrap inference in
STATA using boottest", The STATA Journal.
(\url{https://journals.sagepub.com/doi/full/10.1177/1536867X19830877})

Cameron, A. Colin, Jonah B. Gelbach, and Douglas L. Miller. "Bootstrap-based improvements for inference with clustered errors." The Review of Economics and Statistics 90.3 (2008): 414-427.

MacKinnon, James G., and Matthew D. Webb. "The wild bootstrap for few (treated) clusters." The Econometrics Journal 21.2 (2018): 114-135.

MacKinnon, James. "Wild cluster bootstrap confidence intervals." L'Actualite economique 91.1-2 (2015): 11-33.

Webb, Matthew D. Reworking wild bootstrap based inference for clustered errors. No. 1315. Queen's Economics Department Working Paper, 2013.
}
\seealso{
\link[fwildclusterboot]{boottest.lm}, \link[fwildclusterboot]{boottest.fixest} and \link[fwildclusterboot]{boottest.felm}
}
