% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tidy.mboottest}
\alias{tidy.mboottest}
\title{S3 method to summarize objects of class mboottest into tidy data.frame}
\usage{
\method{tidy}{mboottest}(x, ...)
}
\arguments{
\item{x}{object of type mboottest}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A tidy data.frame with estimation results for objects of type
mboottest
}
\description{
S3 method to summarize objects of class mboottest into tidy data.frame
}
\examples{
\dontrun{
requireNamespace("clubSandwich")
R <- clubSandwich::constrain_zero(2:3, coef(lm_fit))
wboottest <-
  mboottest(
    object = lm_fit,
    clustid = "group_id1",
    B = 999,
    R = R
  )
summary(wboottest)
print(wboottest)
nobs(wboottest)
pval(wboottest)
generics::tidy(wboottest)
}
}
