% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{mboottest}
\alias{mboottest}
\title{Arbitrary Linear Hypothesis Testing for Regression Models via Wald-Tests}
\usage{
mboottest(object, ...)
}
\arguments{
\item{object}{An object of type lm, fixest or felm}

\item{...}{other arguments}
}
\value{
An object of class \code{mboottest}.
}
\description{
\code{mboottest} is a S3 method that allows for arbitrary linear
hypothesis testing
for objects of class lm, fixest, felm
}
\section{Setting Seeds}{

To guarantee reproducibility, you can either use \verb{boottest()'s} \code{seed}
function argument, or
set a global random seed via
\itemize{
\item \code{set.seed()} when using
\enumerate{
\item the lean algorithm (via \code{engine = "R-lean"}),
\item the heteroskedastic wild bootstrap
\item the wild cluster bootstrap via \code{engine = "R"} with Mammen weights or
\item \code{engine = "WildBootTests.jl"}
}
\item \code{dqrng::dqset.seed()} when using \code{engine = "R"} for Rademacher,
Webb or Normal weights
}
}

\examples{
\dontrun{
requireNamespace("clubSandwich")
R <- clubSandwich::constrain_zero(2:3, coef(lm_fit))
wboottest <-
  mboottest(
    object = lm_fit,
    clustid = "group_id1",
    B = 999,
    R = R
  )
summary(wboottest)
print(wboottest)
nobs(wboottest)
pval(wboottest)
generics::tidy(wboottest)
}

}
\references{
Roodman et al., 2019, "Fast and wild: Bootstrap inference in
STATA using boottest", The STATA Journal.
(\url{https://ideas.repec.org/p/qed/wpaper/1406.html})

Cameron, A. Colin, Jonah B. Gelbach, and Douglas L. Miller.
"Bootstrap-based improvements for inference with clustered errors."
The Review of Economics and Statistics 90.3 (2008): 414-427.

Cameron, A.Colin & Douglas L. Miller.
"A practitioner's guide to cluster-robust inference"
Journal of Human Resources (2015) \doi{doi:10.3368/jhr.50.2.317}

Davidson & MacKinnon. "Wild Bootstrap Tests for IV regression"
Journal of Economics and Business Statistics (2010)
\doi{https://doi.org/10.1198/jbes.2009.07221}

MacKinnon, James G., and Matthew D. Webb.
"The wild bootstrap for few (treated) clusters."
The Econometrics Journal 21.2 (2018): 114-135.

MacKinnon, James G., and Matthew D. Webb.
"Cluster-robust inference: A guide to empirical practice"
Journal of Econometrics (2022)
\doi{https://doi.org/10.1016/j.jeconom.2022.04.001}

MacKinnon, James. "Wild cluster bootstrap confidence intervals."
L'Actualite economique 91.1-2 (2015): 11-33.

Webb, Matthew D.
"Reworking wild bootstrap based inference for clustered errors"
. No. 1315. Queen's Economics Department Working Paper, 2013.
}
\seealso{
\link[=mboottest.lm]{mboottest.lm}
\link[=mboottest.felm]{mboottest.felm}
\link[=mboottest.fixest]{mboottest.fixest}
}
