% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_fwb_wtype.R
\name{set_fwb_wtype}
\alias{set_fwb_wtype}
\alias{get_fwb_wtype}
\title{Set weights type}
\usage{
set_fwb_wtype(wtype = getOption("fwb_wtype", "exp"))

get_fwb_wtype(fwb)
}
\arguments{
\item{wtype}{string; the type of weights to use. Allowable options include \code{"exp"} (the default), \code{"pois"}, \code{"multinom"}, and \code{"mammen"}. Abbreviations allowed. See Details for what these mean.}

\item{fwb}{optional; an \code{fwb} objct, the output of a call to \code{\link[=fwb]{fwb()}}. If left empty, will extract the weights type from \code{options()}.}
}
\value{
\code{set_fwb_wtype()} returns a call to \code{\link[=options]{options()}} with the options set to those prior to \code{set_fwb_wtype()} being called. This makes it so that calling \code{options(op)}, where \code{op} is the output of \code{set_fwb_wtype()}, resets the \code{fwb_wtype} to its original value. \code{get_fwb_wtype()} returns a string containing the \code{fwb_wtype} value set globally (if no argument is supplied) or used in the supplied \code{fwb} object.
}
\description{
Set the default for the type of weights used in the weighted bootstrap computed by \code{\link[=fwb]{fwb()}} and \code{\link[=vcovFWB]{vcovFWB()}}.
}
\details{
\code{set_fwb_wtype(x)} is equivalent to calling \code{options(fwb_wtype = x)}. \code{get_fwb_wtype()} is equivalent to calling \code{getOption("fwb_wtype")} when no argument is supplied and to extracting the \code{wtype} component of an \code{fwb} object when supplied.
}
\examples{
\dontshow{if (requireNamespace("survival", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Performing a Weibull analysis of the Bearing Cage
# failure data as done in Xu et al. (2020)
set.seed(123)
data("bearingcage")

#Set fwb type to "mammen"
op <- set_fwb_wtype("mammen")

weibull_est <- function(data, w) {
  fit <- survival::survreg(survival::Surv(hours, failure) ~ 1,
                           data = data, weights = w,
                           dist = "weibull")

  c(eta = unname(exp(coef(fit))), beta = 1/fit$scale)
}

boot_est <- fwb(bearingcage, statistic = weibull_est,
                R = 199, verbose = FALSE)
boot_est

#Get the fwb type used in the bootstrap
get_fwb_wtype(boot_est)
get_fwb_wtype()

#Restore original options
options(op)

get_fwb_wtype()
\dontshow{\}) # examplesIf}
}
\seealso{
\link{fwb} for a definition of each types of weights; \code{\link[=vcovFWB]{vcovFWB()}}; \code{\link[=options]{options()}}; \pkgfun{boot}{boot} for the traditional bootstrap.
}
