% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lee.R
\name{lee}
\alias{lee}
\title{Fuzzy Linear Regression using Lee and Tanaka's Method}
\usage{
lee(x, y, h = 0, k1 = 1, k2 = 1, epsilon = 1e-05)
}
\arguments{
\item{x}{two column matrix with the second column representing independent variable
observations. The first column is related to the intercept, so it consists of ones.
Missing values not allowed.}

\item{y}{one column matrix of dependent variable values, missing values not allowed.}

\item{h}{a scalar value in interval \code{[0,1]}, specifying the h-level.}

\item{k1}{weight coefficient for the centeral tendency.}

\item{k2}{weight coefficient for the spreads.}

\item{epsilon}{small positive number that supports search for the optimal solution.}
}
\value{
Returns a \code{fuzzylm} object that includes the model coefficients, limits
  for data predictions from the model and the input data.
}
\description{
The function calculates fuzzy regression coeficients using method by Lee and Tanaka (1999)
that combines the least squares approach (fitting of a central tendency) with the
possibilistic approach (fitting of spreads) when approximating an observed linear
dependence by a fuzzy linear model.
}
\details{
The function input expects crisp numbers of both the explanatory and response
   variables, and the prediction returns non-symmetric triangular fuzzy number 
   coefficients.
   
   The h-level is a degree of fitting chosen by the decision maker.
}
\note{
Preferred use is through the \code{\link{fuzzylm}} wrapper function with argument
   \code{method = "lee"}.
}
\examples{
x <- matrix(c(rep(1, 15), rep(1:3, each = 5)), ncol = 2)
y <- matrix(c(rnorm(5, 1), rnorm(5, 2), rnorm(5, 3)), ncol = 1)
lee(x = x, y = y)
}
\references{
Lee, H. and Tanaka, H. (1999) Fuzzy approximations with non-symmetric fuzzy
   parameters in fuzzy regression analysis. \emph{Journal of the Operations Research
   Society Japan} 42: 98-112.
}
\seealso{
\code{\link{fuzzylm}}
}
\keyword{fuzzy}
