% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preparation.R
\name{buildStructureExperiments}
\alias{buildStructureExperiments}
\title{Generate file structure for an experiment}
\usage{
buildStructureExperiments(modelName, experiment, dataPath, coordinateFilenames,
  tasFilenames, timeFilenames, dataDirectories)
}
\arguments{
\item{modelName}{Character string of climate model name (e.g., "bcc1"). This
name is generated from the subdirectory name for the climate model within
\code{dataFolder}.}

\item{experiment}{Character string of the experiment. Possible variables are
the names of elements in the list object specified by the
\code{dataDirectories} argument in \code{\link{gen_hw_set}}.}

\item{dataPath}{Character string of the file path to \code{dataFolder}.
Must include the final `/`.}

\item{coordinateFilenames}{Character string the with filename of each
grid point location file. This filename should be identical for all
ensemble member subdirectories included in the \code{dataFolder} directory.
See the package vignette for an example of the required structure for this
file.}

\item{tasFilenames}{Character string the with filename of each climate
projection file. This filename should be identical for all ensemble
member subdirectories included in the \code{dataFolder} directory. See the
package vignette for an example of the required structure for this file.}

\item{timeFilenames}{Character string the with filename of each projection
dates file. This filename should be identical for all ensemble
member  subdirectories included in the \code{dataFolder} directory. See
the package vignette for an example of the required structure for this
file.}

\item{dataDirectories}{A list object, with two elements, one for each of the
two subdirectories included in the main directory. Typically, these will
be separate directories of historical and projection experiments from
climate models. Each element of the list should be named with the name of
the subdirectory and should provide a numeric vector with the starting and
ending years of the data within each of the two subdirectories (e.g.,
\code{list("historical" = c(1990, 1999), "rcp85" = c(2060, 2079))}
for a \code{dataFolder} with historical experiment data for 1990 to 1999
and RCP8.5 projections for 2060 to 2079).}
}
\value{
A list with one element for each ensemble member. Each element
   is a return value of the \code{\link{buildStructureEnsembles}} function for
   one ensemble member in the experiment and climate model.
}
\description{
This function generates a list object with the file structure of files
in the \code{dataFolder} directory for a single experiment
(e.g., "historical" or "rcp85").
}

