% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend_api-01-FutureBackend-class.R,
%   R/backend_api-03.MultiprocessFutureBackend-class.R,
%   R/backend_api-11.ClusterFutureBackend-class.R,
%   R/backend_api-11.MulticoreFutureBackend-class.R,
%   R/backend_api-11.SequentialFutureBackend-class.R,
%   R/backend_api-13.MultisessionFutureBackend-class.R
\name{FutureBackend}
\alias{FutureBackend}
\alias{launchFuture}
\alias{listFutures}
\alias{interruptFuture}
\alias{validateFutureGlobals}
\alias{stopWorkers}
\alias{MultiprocessFutureBackend}
\alias{ClusterFutureBackend}
\alias{MulticoreFutureBackend}
\alias{SequentialFutureBackend}
\alias{MultisessionFutureBackend}
\title{Configure a backend that controls how and where futures are evaluated}
\usage{
FutureBackend(
  ...,
  earlySignal = FALSE,
  gc = FALSE,
  maxSizeOfObjects = getOption("future.globals.maxSize", +Inf),
  interrupts = TRUE,
  hooks = FALSE
)

launchFuture(backend, future, ...)

listFutures(backend, ...)

interruptFuture(backend, future, ...)

validateFutureGlobals(backend, future, ...)

stopWorkers(backend, ...)

MultiprocessFutureBackend(
  ...,
  wait.timeout = getOption("future.wait.timeout", 24 * 60 * 60),
  wait.interval = getOption("future.wait.interval", 0.01),
  wait.alpha = getOption("future.wait.alpha", 1.01)
)

ClusterFutureBackend(
  workers = availableWorkers(constraints = "connections"),
  gc = TRUE,
  earlySignal = TRUE,
  interrupts = FALSE,
  persistent = FALSE,
  ...
)

MulticoreFutureBackend(
  workers = availableCores(constraints = "multicore"),
  maxSizeOfObjects = +Inf,
  ...
)

SequentialFutureBackend(..., maxSizeOfObjects = +Inf)

MultisessionFutureBackend(
  workers = availableCores(),
  rscript_libs = .libPaths(),
  interrupts = TRUE,
  gc = FALSE,
  earlySignal = FALSE,
  ...
)
}
\arguments{
\item{earlySignal}{Overrides the default behavior on whether futures
should resignal ("relay") conditions captured as soon as possible, or
delayed, for instance, until \code{\link[=value]{value()}} is called on the future.
(Default: \code{FALSE})}

\item{gc}{Overrides the default behavior of whether futures should trigger
garbage collection via \code{\link[=gc]{gc()}} on the parallel worker after the value has
been collected from the worker.
This can help to release memory sooner than letting R itself on the parallel
worker decided when it is needed. Releasing memory sooner can help to fit
more parallel workers on a machine with limited amount of total memory.
(Default: \code{FALSE})}

\item{maxSizeOfObjects}{The maximum allowed total size, in bytes, of all
objects to and from the parallel worker allows.
This can help to protect against unexpectedly large data transfers between
the parent process and the parallel workers - data that is often transferred
over the network, which sometimes also includes the internet. For instance,
if you sit at home and have set up a future backend with workers running
remotely at your university or company, then you might want to use this
protection to avoid transferring giga- or terabytes of data without noticing.
(Default: \eqn{500 \cdot 1024^2} bytes = 500 MiB, unless overridden by a
FutureBackend subclass, or by R option \link{future.globals.maxSize} (sic!))}

\item{interrupts}{If FALSE, attempts to interrupt futures will not take
place on this backend, even if the backend supports it. This is useful
when, for instance, it takes a long time to interrupt a future.}

\item{backend}{a \link{FutureBackend}.}

\item{future}{a \link{Future} to be started.}

\item{wait.timeout}{Number of seconds before timing out.}

\item{wait.interval}{Baseline number of seconds between retries.}

\item{wait.alpha}{Scale factor increasing waiting interval after each
attempt.}

\item{workers}{...}

\item{persistent}{(deprecated) ...}

\item{\ldots}{(optional) not used.}
}
\value{
\code{FutureBackend()} returns a FutureBackend object, which inherits an
environment. Specific future backends are defined by subclasses
implementing the FutureBackend API.

\code{launchFuture()} returns the launched \code{Future} object.

\code{interruptFuture()} returns the interrupted \code{Future} object,
if supported, other the unmodified future.

\code{stopWorkers()} returns TRUE if the workers were shut down,
otherwise FALSE.
}
\description{
Configure a backend that controls how and where futures are evaluated

\code{launchFuture()} runs a future on the backend.

\code{interruptFuture()} interrupts a future on the backend.

\code{stopWorkers()} stops backend workers

A ClusterFutureBackend resolves futures in parallel using any PSOCK cluster

A MulticoreFutureBackend resolves futures in parallel using forked processing on the current machine

A SequentialFutureBackend resolves futures sequentially in the current R session

A MultisessionFutureBackend resolves futures in parallel using a PSOCK cluster on the current machine
}
\details{
The \code{ClusterFutureBackend} is selected by
\code{plan(cluster, workers = workers)}.

The \code{MulticoreFutureBackend} backend is selected by
\code{plan(multicore, workers = workers)}.

The \code{SequentialFutureBackend} is selected by \code{plan(sequential)}.

The \code{MultisessionFutureBackend} backend is selected by
\code{plan(multisession, workers = workers)}.
}
\section{The FutureBackend API}{

The \code{FutureBackend} class specifies FutureBackend API,
that all backends must implement and comply to. Specifically,
}

\keyword{internal}
