% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicore.R
\name{requestCore}
\alias{requestCore}
\title{Request a core for multicore processing}
\usage{
requestCore(
  await,
  workers = availableCores(),
  timeout = getOption("future.wait.timeout", 30 * 24 * 60 * 60),
  delta = getOption("future.wait.interval", 0.01),
  alpha = getOption("future.wait.alpha", 1.01)
)
}
\arguments{
\item{await}{A function used to try to "collect"
finished multicore subprocesses.}

\item{workers}{Total number of workers available.}

\item{timeout}{Maximum waiting time (in seconds) allowed
before a timeout error is generated.}

\item{delta}{Then base interval (in seconds) to wait
between each try.}

\item{alpha}{A multiplicative factor used to increase
the wait interval after each try.}
}
\value{
Invisible TRUE. If no cores are available after
extensive waiting, then a timeout error is thrown.
}
\description{
If no cores are available, the current process
blocks until a core is available.
}
\keyword{internal}
