% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchtools_ssh.R
\name{batchtools_ssh}
\alias{batchtools_ssh}
\title{A batchtools backend that resolves futures in parallel via background R sessions over SSH}
\usage{
batchtools_ssh(
  ...,
  workers = availableWorkers(),
  fs.latency = 65,
  delete = getOption("future.batchtools.delete", "on-success")
)
}
\arguments{
\item{workers}{(optional) The maximum number of workers the batchtools
backend may use at any time.   Interactive and "local" backends can only
process one future at the time (\code{workers = 1}), whereas HPC backends,
where futures are resolved via separate jobs on a scheduler, can have
multiple workers. In the latter, the default is \code{workers = NULL}, which
will resolve to \code{getOption("\link{future.batchtools.workers}", 100)}.}

\item{fs.latency}{[\code{numeric(1)}]\cr
Expected maximum latency of the file system, in seconds.
Set to a positive number for network file systems like NFS which enables more robust (but also more expensive) mechanisms to
access files and directories.
Usually safe to set to \code{0} to disable the heuristic, e.g. if you are working on a local file system.}

\item{delete}{Controls if and when the batchtools job registry folder is
deleted.
If \code{"on-success"} (default), it is deleted if the future was resolved
successfully \emph{and} the expression did not produce an error.
If \code{"never"}, then it is never deleted.
If \code{"always"}, then it is always deleted.}
}
\description{
A batchtools backend that resolves futures in parallel via background R sessions over SSH
}
\details{
The \code{batchtools_ssh} backend uses the batchtools backend set
up by \code{\link[batchtools:makeClusterFunctionsSSH]{batchtools::makeClusterFunctionsSSH()}}, which requires
system commands \code{ssh} and \code{ps} as available on Linux and macOS.

An alternative to \code{batchtools_ssh} is to use
\link[future:cluster]{cluster} futures of the \pkg{future}
package with a single local background session, i.e.
\code{plan(cluster, workers = c("localhost"))}.
}
\keyword{internal}
