% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchjobs_template.R
\name{batchjobs_template}
\alias{batchjobs_lsf}
\alias{batchjobs_openlava}
\alias{batchjobs_sge}
\alias{batchjobs_slurm}
\alias{batchjobs_template}
\alias{batchjobs_torque}
\title{BatchJobs LSF, OpenLava, SGE, Slurm and Torque futures}
\usage{
batchjobs_lsf(expr, envir = parent.frame(), substitute = TRUE,
  pathname = NULL, ...)

batchjobs_openlava(expr, envir = parent.frame(), substitute = TRUE,
  pathname = NULL, ...)

batchjobs_sge(expr, envir = parent.frame(), substitute = TRUE,
  pathname = NULL, ...)

batchjobs_slurm(expr, envir = parent.frame(), substitute = TRUE,
  pathname = NULL, ...)

batchjobs_torque(expr, envir = parent.frame(), substitute = TRUE,
  pathname = NULL, ...)
}
\arguments{
\item{expr}{An R expression to be evaluated.}

\item{envir}{The environment from which global environment
are search from.}

\item{substitute}{Controls whether \code{expr} should be
\code{substitute()}:d or not.}

\item{pathname}{A BatchJobs template file (\pkg{brew} formatted).}

\item{\ldots}{Additional arguments passed to \code{\link{BatchJobsFuture}()}.}
}
\value{
An object of class \code{BatchJobsFuture}.
}
\description{
LSF, OpenLava, SGE, Slurm and Torque BatchJobs futures are
asynchronous multiprocess futures that will be evaluated on
a compute cluster via a job scheduler.
}
\details{
These type of BatchJobs futures rely on BatchJobs backends set
up using the following \pkg{BatchJobs} functions:
\itemize{
 \item \code{\link[BatchJobs]{makeClusterFunctionsLSF}()} for \href{https://en.wikipedia.org/wiki/Platform_LSF}{Load Sharing Facility (LSF)}
 \item \code{makeClusterFunctionsOpenLava()} for \href{https://en.wikipedia.org/wiki/OpenLava}{OpenLava} (only BatchJobs (>= 1.7.0))
 \item \code{\link[BatchJobs]{makeClusterFunctionsSGE}()} for \href{https://en.wikipedia.org/wiki/Oracle_Grid_Engine}{Sun/Oracle Grid Engine (SGE)}
 \item \code{\link[BatchJobs]{makeClusterFunctionsSLURM}()} for \href{https://en.wikipedia.org/wiki/Slurm_Workload_Manager}{Slurm}
 \item \code{\link[BatchJobs]{makeClusterFunctionsTorque}()} for \href{https://en.wikipedia.org/wiki/TORQUE}{TORQUE} / PBS
}
}

