# WARNING - Generated by {fusen} from dev/flat_sepuku-utils.Rmd: do not edit by hand # nolint: line_length_linter.

test_that("list_flat_files_in_config_file is a function", {
  expect_true(inherits(list_flat_files_in_config_file, "function"))
})

dummypackage <- tempfile(paste0(sample(letters, 10), collapse = ""))
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
flat_file1 <- add_minimal_package(
  pkg = dummypackage,
  overwrite = TRUE,
  open = FALSE
)
flat_file1 <- flat_file1[grepl("flat_", flat_file1)]


usethis::with_project(dummypackage, {
  # Add licence
  usethis::use_mit_license("John Doe")

  test_that("list_flat_files works when no fusen config file is present", {
    identified_flat_files <- list_flat_files_in_config_file()
    expect_true(!is.null(identified_flat_files))
    expect_equal(length(identified_flat_files), 0)
  })
})

usethis::with_project(dummypackage, {
  test_that("list_flat_files works for a fusen config file", {
    flat_file2 <- add_minimal_flat(
      pkg = dummypackage,
      flat_name = "XXX_flat2.Rmd",
      open = FALSE
    )

    inflate(
      pkg = dummypackage,
      flat_file = flat_file1,
      vignette_name = "Get started",
      check = FALSE,
      open_vignette = FALSE,
      document = TRUE,
      overwrite = "yes"
    )

    inflate(
      pkg = dummypackage,
      flat_file = flat_file2,
      vignette_name = "Get started 2",
      check = FALSE,
      open_vignette = FALSE,
      document = TRUE,
      overwrite = "yes"
    )

    identified_flat_files <- list_flat_files_in_config_file()

    expect_equal(
      length(identified_flat_files),
      2
    )

    expect_true(
      all(
        identified_flat_files %in%
          c("dev/flat_minimal.Rmd", "dev/flat_xxx_flat2.Rmd")
      )
    )
  })
})
unlink(dummypackage, recursive = TRUE)

test_that("list_flat_files_in_dev_folder is a function", {
  expect_true(inherits(list_flat_files_in_dev_folder, "function"))
})

dummypackage <- tempfile(paste0(sample(letters, 10), collapse = ""))
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
flat_file1 <- add_minimal_package(
  pkg = dummypackage,
  overwrite = TRUE,
  open = FALSE
)
flat_file1 <- flat_file1[grepl("flat_", flat_file1)]


usethis::with_project(dummypackage, {
  # Add licence
  usethis::use_mit_license("John Doe")

  test_that("list_flat_files_in_dev_folder works for Rmd and qmd files in dev folder starting with flat", {
    flat_file_with_bad_name <- "xxx_flat2.Rmd"
    file.create(file.path(dummypackage, "dev", flat_file_with_bad_name))

    identified_flat_files <- list_flat_files_in_dev_folder()

    expect_equal(identified_flat_files, "dev/flat_minimal.Rmd")

    qmd_file <- "flat_minimal.qmd"

    file.create(file.path(dummypackage, "dev", qmd_file))

    identified_flat_files <- list_flat_files_in_dev_folder()

    expect_equal(
      length(identified_flat_files),
      2
    )

    expect_true(
      all(
        identified_flat_files %in% c("dev/flat_minimal.Rmd", "dev/flat_minimal.qmd")
      )
    )
  })

  test_that("list_flat_files_in_dev_folder works for Rmd and qmd files in flat_history folder starting with flat", {
    inflate(
      pkg = dummypackage,
      flat_file = flat_file1,
      vignette_name = NA,
      check = FALSE,
      open_vignette = FALSE,
      document = TRUE,
      overwrite = "yes"
    )

    deprecate_flat_file(
      flat_file = flat_file1
    )

    identified_flat_files <- list_flat_files_in_dev_folder(folder = "dev/flat_history")

    expect_equal(identified_flat_files, "dev/flat_history/flat_minimal.Rmd")

    qmd_file <- "flat_minimal.qmd"

    file.create(file.path(dummypackage, "dev/flat_history", qmd_file))

    identified_flat_files <- list_flat_files_in_dev_folder(folder = "dev/flat_history")

    expect_equal(
      length(identified_flat_files),
      2
    )

    expect_true(
      all(
        identified_flat_files %in% c("dev/flat_history/flat_minimal.Rmd", "dev/flat_history/flat_minimal.qmd")
      )
    )
  })
})
unlink(dummypackage, recursive = TRUE)

test_that("list_flat_files is a function", {
  expect_true(inherits(list_flat_files, "function"))
})

dummypackage <- tempfile(paste0(sample(letters, 10), collapse = ""))
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))

usethis::with_project(dummypackage, {
  # Add licence
  usethis::use_mit_license("John Doe")

  test_that("list_flat_files works with an empty pkg", {
    flat_files <- list_flat_files()
    expect_equal(length(flat_files), 0)
  })

  test_that("list_flat_files works with flat files in dev but no config file", {
    dev_file1 <- add_minimal_flat(
      pkg = dummypackage,
      flat_name = "flat1.Rmd",
      open = FALSE
    )

    file.create(file.path(dummypackage, "dev", "flat_1.qmd"))
    file.create(file.path(dummypackage, "dev", "wrong_flat1.Rmd"))
    file.create(file.path(dummypackage, "dev", "wrong_flat1.qmd"))

    flat_files <- list_flat_files()
    expect_equal(
      length(flat_files),
      2
    )

    expect_true(
      all(
        flat_files %in% c("dev/flat_flat1.Rmd", "dev/flat_1.qmd")
      )
    )
  })

  test_that("list_flat_files works with flat files in dev and a config file", {
    dev_file1 <- add_minimal_flat(
      pkg = dummypackage,
      flat_name = "flat1.Rmd",
      open = FALSE,
      overwrite = TRUE
    )

    inflate(
      pkg = dummypackage,
      flat_file = dev_file1,
      vignette_name = "Get started",
      check = FALSE,
      open_vignette = FALSE,
      document = TRUE,
      overwrite = "yes"
    )

    flat_files <- list_flat_files()
    expect_equal(
      length(flat_files),
      2
    )

    expect_true(
      all(
        flat_files %in% c("dev/flat_flat1.Rmd", "dev/flat_1.qmd")
      )
    )
  })

  test_that("list_flat_files works with a deprecated flat file", {
    dev_file1 <- add_minimal_flat(
      pkg = dummypackage,
      flat_name = "flat1.Rmd",
      open = FALSE,
      overwrite = TRUE
    )

    inflate(
      pkg = dummypackage,
      flat_file = dev_file1,
      vignette_name = "Get started",
      check = FALSE,
      open_vignette = FALSE,
      document = TRUE,
      overwrite = "yes"
    )

    deprecate_flat_file(
      flat_file = dev_file1
    )

    flat_files <- list_flat_files()
    expect_equal(
      length(flat_files),
      2
    )

    expect_true(
      all(
        flat_files %in% c("dev/flat_history/flat_flat1.Rmd", "dev/flat_1.qmd")
      )
    )
  })
})
unlink(dummypackage, recursive = TRUE)

test_that("find_files_with_fusen_tags is a function", {
  expect_true(inherits(find_files_with_fusen_tags, "function"))
})

dummypackage <- tempfile(paste0(sample(letters, 10), collapse = ""))
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))

usethis::with_project(dummypackage, {
  # Add licence
  usethis::use_mit_license("John Doe")
  test_that("find_files_with_fusen_tags works with an empty pkg", {
    files_with_fusen_tags <- find_files_with_fusen_tags()
    expect_equal(length(files_with_fusen_tags), 0)
  })

  test_that("find_files_with_fusen_tags identifies files created by fusen", {
    dev_file1 <- add_minimal_flat(
      pkg = dummypackage,
      flat_name = "flat1.Rmd",
      open = FALSE,
      overwrite = TRUE
    )

    inflate(
      pkg = dummypackage,
      flat_file = dev_file1,
      vignette_name = "Get started",
      check = FALSE,
      open_vignette = FALSE,
      document = TRUE,
      overwrite = "yes"
    )

    files_with_fusen_tags <- find_files_with_fusen_tags()
    expect_equal(length(files_with_fusen_tags), 3)
    expect_true(
      all(
        files_with_fusen_tags %in%
          c("R/flat1_rmd.R", "vignettes/get-started.Rmd", "tests/testthat/test-flat1_rmd.R")
      )
    )
  })

  test_that("find_files_with_fusen_tags do not identify files not created by fusen", {
    usethis::use_r("donotfindme.R", open = FALSE)
    usethis::use_test("donotfindme.R", open = FALSE)
    file.create(file.path(dummypackage, "vignettes", "donotfindme.Rmd"))

    files_with_fusen_tags <- find_files_with_fusen_tags()
    expect_equal(length(files_with_fusen_tags), 3)
    expect_true(
      all(
        files_with_fusen_tags %in%
          c("R/flat1_rmd.R", "vignettes/get-started.Rmd", "tests/testthat/test-flat1_rmd.R")
      )
    )
  })
})
unlink(dummypackage, recursive = TRUE)

test_that("clean_fusen_tags_in_files is a function", {
  expect_true(inherits(clean_fusen_tags_in_files, "function"))
})

dummypackage <- tempfile(paste0(sample(letters, 10), collapse = ""))
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
usethis::with_project(dummypackage, {
  # Add licence
  usethis::use_mit_license("John Doe")

  dev_file1 <- add_minimal_flat(
    pkg = dummypackage,
    flat_name = "flat1.Rmd",
    open = FALSE,
    overwrite = TRUE
  )
  inflate(
    pkg = dummypackage,
    flat_file = dev_file1,
    vignette_name = "Get started",
    check = FALSE,
    open_vignette = FALSE,
    document = TRUE,
    overwrite = "yes"
  )
  files_with_fusen_tags <- find_files_with_fusen_tags(pkg = dummypackage)



  test_that("clean_fusen_tags_in_files works with an empty pkg", {
    cleaned_files <- clean_fusen_tags_in_files(pkg = dummypackage, files_to_clean = files_with_fusen_tags)
    cleaned_files_with_fusen_tags <- find_files_with_fusen_tags()
    expect_equal(length(cleaned_files_with_fusen_tags), 0)
  })
})
unlink(dummypackage, recursive = TRUE)
