% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_dev_history.R
\name{add_dev_history}
\alias{add_dev_history}
\title{Add dev_history.Rmd file that drives package development}
\usage{
add_dev_history(
  pkg = ".",
  overwrite = FALSE,
  open = TRUE,
  dev_dir = "dev",
  name = c("full", "minimal", "additional", "teaching")
)
}
\arguments{
\item{pkg}{Path where to save file}

\item{overwrite}{Whether to overwrite existing dev_history.Rmd file}

\item{open}{Logical. Whether to open file after creation}

\item{dev_dir}{Name of directory for development Rmarkdown files. Default to "dev".}

\item{name}{Name of the template file. See \code{\link[=add_flat_template]{add_flat_template()}}}
}
\value{
Create flat Rmd file(s) and return its (their) path
}
\description{
\code{add_dev_history()} is deprecated. We will soon be totally
switching to \code{\link[=add_flat_template]{add_flat_template()}}, which is more consistent with development
processes

\code{add_dev_history(name = "teaching")} is equivalent to
\code{add_flat_template(template = "teaching")}
}
\examples{
# Create a new project
dummypackage <- tempfile("dummypackage")
dir.create(dummypackage)

# Add - Use `add_flat_template()` instead
add_flat_template(template = "teaching", pkg = dummypackage)

# Delete dummy package
unlink(dummypackage, recursive = TRUE)
}
