% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestLayerLearner.R
\name{bestLayerLearner}
\alias{bestLayerLearner}
\title{The best layer-specific model is used as meta model.}
\usage{
bestLayerLearner(x, y, perf = NULL)
}
\arguments{
\item{x}{\code{data.frame} \cr
\code{data.frame} of predictors.}

\item{y}{\code{vector} \cr
True target observations. Either binary or two level factor variable.}

\item{perf}{\code{function} \cr
Function to compute layer-specific performance of learners. If NULL, the Brier Score (classification) or a mean squared error (regression) is used by default as performance measure.
Otherwise, the performance function must accept two parameters: \code{observed} (observed values) and \code{predicted} (predicted values).}
}
\value{
A model object of class \code{weightedMeanLeaner}.
}
\description{
The meta learner is the best layer-specific learner. This function is intended to be (internally) used as meta-learner in fuseMLR.
}
\examples{
set.seed(20240624L)
x = data.frame(x1 = runif(n = 50L, min = 0, max = 1))
y = sample(x = 0L:1L, size = 50L, replace = TRUE)
my_best_model = bestLayerLearner(x = x, y = y)
}
