% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd_fric_intersect.R
\name{fd_fric_intersect}
\alias{fd_fric_intersect}
\title{Intersection between convex hulls of pairs of sites}
\usage{
fd_fric_intersect(traits, sp_com, stand = FALSE)
}
\arguments{
\item{traits}{Trait matrix with species as rows and traits as columns.
It has to contain exclusively numerical values. This can be
either a \code{matrix}, a \code{data.frame}, or a \code{\link[Matrix:Matrix]{Matrix::Matrix()}}
object.}

\item{sp_com}{Site-species matrix with sites as rows and species as columns
if not provided, the function considers all species with equal
abundance in a single site. This can be either a \code{matrix},
a \code{data.frame}, or a \code{\link[Matrix:Matrix]{Matrix::Matrix()}} object.}

\item{stand}{a boolean indicating whether to standardize FRic values over
the observed maximum over all species (default: \code{FALSE}).
This scales FRic between 0 and 1.
\strong{NB}: The maximum FRic values only considers species that are
present in \strong{both} site-species and trait matrices.
If you want to consider species that are absent
in the site-species matrix, add corresponding columns of 0s.}
}
\value{
a data.frame with three columns:
\itemize{
\item \code{first_site} the names of the first site used in the pair \code{sp_com},
\item \code{second_site} the names of the first site used in the pair,
\item \code{FRic_intersect} the volume of the convex hulls intersection of each
pair of site.
}

NB: FRic_intersect is equal to \code{NA} when there are strictly less species in
one of the sites than the number of provided traits.
}
\description{
Compute volume of the intersection of the convex hulls of all pairs
of sites (including self-intersection, which corresponds to their convex
hull). Note that when standardizing convex hulls of intersections,
this function uses the convex hull of all provided traits,
thus standardized volume of self-intersection hulls can be lower than one.
}
\details{
By default, when loading \pkg{fundiversity}, the functions to
compute convex hulls are
\href{https://en.wikipedia.org/wiki/Memoization}{memoised} through the \code{memoise}
package if it is installed. To deactivate this behavior you can set the
option \code{fundiversity.memoise} to \code{FALSE} by running the following line:
\code{options(fundiversity.memoise = FALSE)}. If you use it interactively it will
only affect your current session. Add it to your script(s) or \code{.Rprofile}
file to avoid toggling it each time.
}
\section{Parallelization}{

The computation of this function can be parallelized thanks to
\code{\link[future:plan]{future::plan()}}. To get more information on how to parallelize your
computation please refer to the parallelization vignette with:
\code{vignette("parallel", package = "fundiversity")}
}

\examples{
data(traits_birds)
fd_fric_intersect(traits_birds)

}
\seealso{
\code{\link[=fd_fric]{fd_fric()}}, \code{\link[geometry:intersectn]{geometry::intersectn()}}, \code{\link[geometry:convhulln]{geometry::convhulln()}}
}
