% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find-functions.R
\name{find_functions}
\alias{find_functions}
\title{Functions in path}
\usage{
find_functions(path, envir = .GlobalEnv, recursive = TRUE)
}
\arguments{
\item{path}{Character, path to folder}

\item{envir}{Environment to source loaded functions into}

\item{recursive}{Logical, whether to search files recursively}
}
\value{
A tibble with character columns indicating path to source files and names of functions
    defined in them. Path elements are split into columns with `Level` prefix,
    name of source file is in `Source` column, name of function is in `Function` column.
}
\description{
Parses files in given path. It searches for functions and loads them. Is safe for use with scripts
as it doesn't source the whole file, just functions. There are no side-effects to sourcing .R files.
}
\examples{
\donttest{
path <- file.path(tempdir(), "find_functions_example")
dir.create(path, showWarnings = FALSE)
code <- "
add <- function(x, y) {
  x + y
}
add_one = function(x) {
  add(x, 1)
}
assign('add_two', function(x) {
  add(x, 2)
})
"
write(code, file.path(path, "code.R"))
find_functions(path)
}
}
