% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{mean_mfd}
\alias{mean_mfd}
\title{Mean Function for Multivariate Functional Data}
\usage{
mean_mfd(mfdobj)
}
\arguments{
\item{mfdobj}{An object of class \code{mfd} representing the multivariate functional data.
It contains \eqn{N} observations of a \eqn{p}-dimensional multivariate functional variable.}
}
\value{
An \code{mfd} object representing the mean function of the input data. The output contains
one observation, representing the mean function for each dimension of the multivariate functional variable.
}
\description{
Computes the mean function for a multivariate functional data object of class \code{mfd}.
}
\details{
This function calculates the mean function for each dimension of the multivariate functional data
by averaging the coefficients across all observations. The resulting object is a single observation
containing the mean function for each dimension.
}
\examples{
\dontrun{
library(funcharts)
data(air)
mfdobj <- get_mfd_list(air)
mean_result <- mean_mfd(mfdobj)
plot_mfd(mean_result)
}

}
