% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{[.mfd}
\alias{[.mfd}
\title{Extract observations and/or variables from \code{mfd} objects.}
\usage{
\method{[}{mfd}(mfdobj, i = TRUE, j = TRUE)
}
\arguments{
\item{mfdobj}{An object of class \code{mfd}.}

\item{i}{Index specifying functional observations to extract or replace.
They can be numeric, character,
or logical vectors or empty (missing) or NULL.
Numeric values are coerced to integer as by as.integer
(and hence truncated towards zero).
The can also be negative integers,
indicating functional observations to leave out of the selection.
Logical vectors indicate TRUE for the observations to select.
Character vectors will be matched
to the argument \code{fdnames[[2]]} of \code{mfdobj},
i.e. to functional observations' names.}

\item{j}{Index specifying functional variables to extract or replace.
They can be numeric, logical,
or character vectors or empty (missing) or NULL.
Numeric values are coerced to integer as by as.integer
(and hence truncated towards zero).
The can also be negative integers,
indicating functional variables to leave out of the selection.
Logical vectors indicate TRUE for the variables to select.
Character vectors will be matched
to the argument \code{fdnames[[3]]} of \code{mfdobj},
i.e. to functional variables' names.}
}
\value{
a \code{mfd} object with selected observations and variables.
}
\description{
Extract observations and/or variables from \code{mfd} objects.
}
\details{
This function adapts the \code{fda::"[.fd"}
function to be more robust and suitable
for the \code{mfd} class.
In fact, whatever the number of observations
or variables you want to extract,
it always returns a \code{mfd} object with a three-dimensional coef array.
In other words, it behaves as you would
always use the argument \code{drop=FALSE}.
Moreover, you can extract observations
and variables both by index numbers and by names,
as you would normally do when using
\code{`[`} with standard vector/matrices.
}
\examples{
library(funcharts)

# In the following, we extract the first one/two observations/variables
# to see the difference with `[.fd`.
mfdobj <- data_sim_mfd()
fdobj <- fd(mfdobj$coefs, mfdobj$basis, mfdobj$fdnames)

# The argument `coef` in `fd` objects is converted to a matrix when possible.
dim(fdobj[1, 1]$coef)
# Not clear what is the second dimension:
# the number of replications or the number of variables?
dim(fdobj[1, 1:2]$coef)
dim(fdobj[1:2, 1]$coef)

# The argument `coef` in `mfd` objects is always a three-dimensional array.
dim(mfdobj[1, 1]$coef)
dim(mfdobj[1, 1:2]$coef)
dim(mfdobj[1:2, 1]$coef)

# Actually, `[.mfd` works as `[.fd` when passing also `drop = FALSE`
dim(fdobj[1, 1, drop = FALSE]$coef)
dim(fdobj[1, 1:2, drop = FALSE]$coef)
dim(fdobj[1:2, 1, drop = FALSE]$coef)

}
